@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.TieringPolicyArgs.builder
import com.pulumi.azurenative.workloads.kotlin.enums.RetentionDurationType
import com.pulumi.azurenative.workloads.kotlin.enums.TieringMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Tiering Policy for a target tier.
 * If the policy is not specified for a given target tier, service retains the existing configured tiering policy for that tier
 * @property duration Number of days/weeks/months/years to retain backups in current tier before tiering.
 * Used only if TieringMode is set to TierAfter
 * @property durationType Retention duration type: days/weeks/months/years
 * Used only if TieringMode is set to TierAfter
 * @property tieringMode Tiering Mode to control automatic tiering of recovery points. Supported values are:
 * 1. TierRecommended: Tier all recovery points recommended to be tiered
 * 2. TierAfter: Tier all recovery points after a fixed period, as specified in duration + durationType below.
 * 3. DoNotTier: Do not tier any recovery points
 */
public data class TieringPolicyArgs(
    public val duration: Output<Int>? = null,
    public val durationType: Output<Either<String, RetentionDurationType>>? = null,
    public val tieringMode: Output<Either<String, TieringMode>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.TieringPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.TieringPolicyArgs =
        com.pulumi.azurenative.workloads.inputs.TieringPolicyArgs.builder()
            .duration(duration?.applyValue({ args0 -> args0 }))
            .durationType(
                durationType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .tieringMode(
                tieringMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [TieringPolicyArgs].
 */
@PulumiTagMarker
public class TieringPolicyArgsBuilder internal constructor() {
    private var duration: Output<Int>? = null

    private var durationType: Output<Either<String, RetentionDurationType>>? = null

    private var tieringMode: Output<Either<String, TieringMode>>? = null

    /**
     * @param value Number of days/weeks/months/years to retain backups in current tier before tiering.
     * Used only if TieringMode is set to TierAfter
     */
    @JvmName("akdkmqwsleuebege")
    public suspend fun duration(`value`: Output<Int>) {
        this.duration = value
    }

    /**
     * @param value Retention duration type: days/weeks/months/years
     * Used only if TieringMode is set to TierAfter
     */
    @JvmName("uyipxjqaycaacqhc")
    public suspend fun durationType(`value`: Output<Either<String, RetentionDurationType>>) {
        this.durationType = value
    }

    /**
     * @param value Tiering Mode to control automatic tiering of recovery points. Supported values are:
     * 1. TierRecommended: Tier all recovery points recommended to be tiered
     * 2. TierAfter: Tier all recovery points after a fixed period, as specified in duration + durationType below.
     * 3. DoNotTier: Do not tier any recovery points
     */
    @JvmName("taefiawpeewqorfx")
    public suspend fun tieringMode(`value`: Output<Either<String, TieringMode>>) {
        this.tieringMode = value
    }

    /**
     * @param value Number of days/weeks/months/years to retain backups in current tier before tiering.
     * Used only if TieringMode is set to TierAfter
     */
    @JvmName("gclyypgsjvqitadi")
    public suspend fun duration(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.duration = mapped
    }

    /**
     * @param value Retention duration type: days/weeks/months/years
     * Used only if TieringMode is set to TierAfter
     */
    @JvmName("fivnqhbsvpcoiotm")
    public suspend fun durationType(`value`: Either<String, RetentionDurationType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.durationType = mapped
    }

    /**
     * @param value Retention duration type: days/weeks/months/years
     * Used only if TieringMode is set to TierAfter
     */
    @JvmName("tpxyynnngvditmhg")
    public fun durationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RetentionDurationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.durationType = mapped
    }

    /**
     * @param value Retention duration type: days/weeks/months/years
     * Used only if TieringMode is set to TierAfter
     */
    @JvmName("yoywtnxiygbfjbro")
    public fun durationType(`value`: RetentionDurationType) {
        val toBeMapped = Either.ofRight<String, RetentionDurationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.durationType = mapped
    }

    /**
     * @param value Tiering Mode to control automatic tiering of recovery points. Supported values are:
     * 1. TierRecommended: Tier all recovery points recommended to be tiered
     * 2. TierAfter: Tier all recovery points after a fixed period, as specified in duration + durationType below.
     * 3. DoNotTier: Do not tier any recovery points
     */
    @JvmName("aooywckpiwhsplla")
    public suspend fun tieringMode(`value`: Either<String, TieringMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tieringMode = mapped
    }

    /**
     * @param value Tiering Mode to control automatic tiering of recovery points. Supported values are:
     * 1. TierRecommended: Tier all recovery points recommended to be tiered
     * 2. TierAfter: Tier all recovery points after a fixed period, as specified in duration + durationType below.
     * 3. DoNotTier: Do not tier any recovery points
     */
    @JvmName("ocgfkuygxghkpaoi")
    public fun tieringMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, TieringMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tieringMode = mapped
    }

    /**
     * @param value Tiering Mode to control automatic tiering of recovery points. Supported values are:
     * 1. TierRecommended: Tier all recovery points recommended to be tiered
     * 2. TierAfter: Tier all recovery points after a fixed period, as specified in duration + durationType below.
     * 3. DoNotTier: Do not tier any recovery points
     */
    @JvmName("whxdmwfpfkognpnx")
    public fun tieringMode(`value`: TieringMode) {
        val toBeMapped = Either.ofRight<String, TieringMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tieringMode = mapped
    }

    internal fun build(): TieringPolicyArgs = TieringPolicyArgs(
        duration = duration,
        durationType = durationType,
        tieringMode = tieringMode,
    )
}
