@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.UserAssignedManagedIdentityDetailsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * User assigned managed identity details.
 * @property identityArmId
 * @property identityName
 * @property userAssignedIdentityProperties User assigned managed identity properties.
 */
public data class UserAssignedManagedIdentityDetailsArgs(
    public val identityArmId: Output<String>? = null,
    public val identityName: Output<String>? = null,
    public val userAssignedIdentityProperties: Output<UserAssignedIdentityPropertiesArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.UserAssignedManagedIdentityDetailsArgs> {
    override fun toJava():
        com.pulumi.azurenative.workloads.inputs.UserAssignedManagedIdentityDetailsArgs =
        com.pulumi.azurenative.workloads.inputs.UserAssignedManagedIdentityDetailsArgs.builder()
            .identityArmId(identityArmId?.applyValue({ args0 -> args0 }))
            .identityName(identityName?.applyValue({ args0 -> args0 }))
            .userAssignedIdentityProperties(
                userAssignedIdentityProperties?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            ).build()
}

/**
 * Builder for [UserAssignedManagedIdentityDetailsArgs].
 */
@PulumiTagMarker
public class UserAssignedManagedIdentityDetailsArgsBuilder internal constructor() {
    private var identityArmId: Output<String>? = null

    private var identityName: Output<String>? = null

    private var userAssignedIdentityProperties: Output<UserAssignedIdentityPropertiesArgs>? = null

    /**
     * @param value
     */
    @JvmName("jfatmprkgnsecjbq")
    public suspend fun identityArmId(`value`: Output<String>) {
        this.identityArmId = value
    }

    /**
     * @param value
     */
    @JvmName("mxghendukbgqvnlm")
    public suspend fun identityName(`value`: Output<String>) {
        this.identityName = value
    }

    /**
     * @param value User assigned managed identity properties.
     */
    @JvmName("tibcyebitlwwqbbw")
    public suspend
    fun userAssignedIdentityProperties(`value`: Output<UserAssignedIdentityPropertiesArgs>) {
        this.userAssignedIdentityProperties = value
    }

    /**
     * @param value
     */
    @JvmName("xcpqukoiknhamlpq")
    public suspend fun identityArmId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityArmId = mapped
    }

    /**
     * @param value
     */
    @JvmName("oynddblswkstvjko")
    public suspend fun identityName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityName = mapped
    }

    /**
     * @param value User assigned managed identity properties.
     */
    @JvmName("amnrjrcdekraksol")
    public suspend fun userAssignedIdentityProperties(`value`: UserAssignedIdentityPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentityProperties = mapped
    }

    /**
     * @param argument User assigned managed identity properties.
     */
    @JvmName("tqjujfieqnivrorr")
    public suspend
    fun userAssignedIdentityProperties(argument: suspend UserAssignedIdentityPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = UserAssignedIdentityPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.userAssignedIdentityProperties = mapped
    }

    internal fun build(): UserAssignedManagedIdentityDetailsArgs =
        UserAssignedManagedIdentityDetailsArgs(
            identityArmId = identityArmId,
            identityName = identityName,
            userAssignedIdentityProperties = userAssignedIdentityProperties,
        )
}
