@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.inputs

import com.pulumi.azurenative.workloads.inputs.VMBackupDataArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Defines the VM Backup data for a virtual instance for SAP.
 * @property backupPolicy Defines the policy properties for virtual machine backup.
 * @property backupType The type of backup, VM, SQL or HANA.
 * Expected value is 'VM'.
 * @property diskExclusionProperties Defines the disk exclusion properties for virtual machine backup.
 * @property recoveryServicesVault The properties of the recovery services vault used for backup.
 */
public data class VMBackupDataArgs(
    public val backupPolicy: Output<VMBackupPolicyPropertiesArgs>,
    public val backupType: Output<String>,
    public val diskExclusionProperties: Output<DiskExclusionPropertiesArgs>? = null,
    public val recoveryServicesVault:
    Output<Either<ExistingRecoveryServicesVaultArgs, NewRecoveryServicesVaultArgs>>,
) : ConvertibleToJava<com.pulumi.azurenative.workloads.inputs.VMBackupDataArgs> {
    override fun toJava(): com.pulumi.azurenative.workloads.inputs.VMBackupDataArgs =
        com.pulumi.azurenative.workloads.inputs.VMBackupDataArgs.builder()
            .backupPolicy(backupPolicy.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .backupType(backupType.applyValue({ args0 -> args0 }))
            .diskExclusionProperties(
                diskExclusionProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .recoveryServicesVault(
                recoveryServicesVault.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [VMBackupDataArgs].
 */
@PulumiTagMarker
public class VMBackupDataArgsBuilder internal constructor() {
    private var backupPolicy: Output<VMBackupPolicyPropertiesArgs>? = null

    private var backupType: Output<String>? = null

    private var diskExclusionProperties: Output<DiskExclusionPropertiesArgs>? = null

    private var recoveryServicesVault:
        Output<Either<ExistingRecoveryServicesVaultArgs, NewRecoveryServicesVaultArgs>>? = null

    /**
     * @param value Defines the policy properties for virtual machine backup.
     */
    @JvmName("jpaqoahrfidsvlit")
    public suspend fun backupPolicy(`value`: Output<VMBackupPolicyPropertiesArgs>) {
        this.backupPolicy = value
    }

    /**
     * @param value The type of backup, VM, SQL or HANA.
     * Expected value is 'VM'.
     */
    @JvmName("kvsouvyhlgkqkvim")
    public suspend fun backupType(`value`: Output<String>) {
        this.backupType = value
    }

    /**
     * @param value Defines the disk exclusion properties for virtual machine backup.
     */
    @JvmName("ebilolwoaxosajmw")
    public suspend fun diskExclusionProperties(`value`: Output<DiskExclusionPropertiesArgs>) {
        this.diskExclusionProperties = value
    }

    /**
     * @param value The properties of the recovery services vault used for backup.
     */
    @JvmName("vtothwfxrukyrces")
    public suspend
    fun recoveryServicesVault(`value`: Output<Either<ExistingRecoveryServicesVaultArgs, NewRecoveryServicesVaultArgs>>) {
        this.recoveryServicesVault = value
    }

    /**
     * @param value Defines the policy properties for virtual machine backup.
     */
    @JvmName("wgkoyjnjrqexgixa")
    public suspend fun backupPolicy(`value`: VMBackupPolicyPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupPolicy = mapped
    }

    /**
     * @param argument Defines the policy properties for virtual machine backup.
     */
    @JvmName("tfupkxachidkoxjd")
    public suspend
    fun backupPolicy(argument: suspend VMBackupPolicyPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = VMBackupPolicyPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.backupPolicy = mapped
    }

    /**
     * @param value The type of backup, VM, SQL or HANA.
     * Expected value is 'VM'.
     */
    @JvmName("mfughodroouqtyrn")
    public suspend fun backupType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.backupType = mapped
    }

    /**
     * @param value Defines the disk exclusion properties for virtual machine backup.
     */
    @JvmName("lhsgguqvxqerclwt")
    public suspend fun diskExclusionProperties(`value`: DiskExclusionPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.diskExclusionProperties = mapped
    }

    /**
     * @param argument Defines the disk exclusion properties for virtual machine backup.
     */
    @JvmName("drqydgpmlxdrairs")
    public suspend
    fun diskExclusionProperties(argument: suspend DiskExclusionPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = DiskExclusionPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.diskExclusionProperties = mapped
    }

    /**
     * @param value The properties of the recovery services vault used for backup.
     */
    @JvmName("gkjhorasytabapye")
    public suspend
    fun recoveryServicesVault(`value`: Either<ExistingRecoveryServicesVaultArgs, NewRecoveryServicesVaultArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recoveryServicesVault = mapped
    }

    /**
     * @param value The properties of the recovery services vault used for backup.
     */
    @JvmName("pwoptxvllhwnulyd")
    public fun recoveryServicesVault(`value`: ExistingRecoveryServicesVaultArgs) {
        val toBeMapped = Either.ofLeft<ExistingRecoveryServicesVaultArgs,
            NewRecoveryServicesVaultArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recoveryServicesVault = mapped
    }

    /**
     * @param value The properties of the recovery services vault used for backup.
     */
    @JvmName("qofhftnqcluqsbhb")
    public fun recoveryServicesVault(`value`: NewRecoveryServicesVaultArgs) {
        val toBeMapped = Either.ofRight<ExistingRecoveryServicesVaultArgs,
            NewRecoveryServicesVaultArgs,>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.recoveryServicesVault = mapped
    }

    internal fun build(): VMBackupDataArgs = VMBackupDataArgs(
        backupPolicy = backupPolicy ?: throw PulumiNullFieldException("backupPolicy"),
        backupType = backupType ?: throw PulumiNullFieldException("backupType"),
        diskExclusionProperties = diskExclusionProperties,
        recoveryServicesVault = recoveryServicesVault ?: throw
            PulumiNullFieldException("recoveryServicesVault"),
    )
}
