@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 * Day of the week.
 * @property date Date of the month
 * @property isLast Whether Date is last date of month
 */
public data class DayResponse(
    public val date: Int? = null,
    public val isLast: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.DayResponse): DayResponse =
            DayResponse(
                date = javaType.date().map({ args0 -> args0 }).orElse(null),
                isLast = javaType.isLast().map({ args0 -> args0 }).orElse(null),
            )
    }
}
