@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the url and storage account ID where deployer VM packages are uploaded
 * @property storageAccountId The deployer VM packages storage account id
 * @property url The URL to the deployer VM packages file.
 */
public data class DeployerVmPackagesResponse(
    public val storageAccountId: String? = null,
    public val url: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.DeployerVmPackagesResponse):
            DeployerVmPackagesResponse = DeployerVmPackagesResponse(
            storageAccountId = javaType.storageAccountId().map({ args0 -> args0 }).orElse(null),
            url = javaType.url().map({ args0 -> args0 }).orElse(null),
        )
    }
}
