@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import com.pulumi.core.Either
import kotlin.Any
import kotlin.String
import kotlin.Suppress

/**
 * Deployment along with OS Configuration.
 * @property appLocation The geo-location where the SAP system is to be created.
 * @property configurationType The configuration Type.
 * Expected value is 'DeploymentWithOSConfig'.
 * @property infrastructureConfiguration The infrastructure configuration.
 * @property osSapConfiguration The OS and SAP configuration.
 * @property softwareConfiguration The software configuration.
 */
public data class DeploymentWithOSConfigurationResponse(
    public val appLocation: String? = null,
    public val configurationType: String,
    public val infrastructureConfiguration:
    Either<SingleServerConfigurationResponse, ThreeTierConfigurationResponse>? = null,
    public val osSapConfiguration: OsSapConfigurationResponse? = null,
    public val softwareConfiguration: Any? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.DeploymentWithOSConfigurationResponse):
            DeploymentWithOSConfigurationResponse = DeploymentWithOSConfigurationResponse(
            appLocation = javaType.appLocation().map({ args0 -> args0 }).orElse(null),
            configurationType = javaType.configurationType(),
            infrastructureConfiguration = javaType.infrastructureConfiguration().map({ args0 ->
                args0.transform(
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.workloads.kotlin.outputs.SingleServerConfigurationResponse.Companion.toKotlin(args0)
                        })
                    },
                    { args0 ->
                        args0.let({ args0 ->
                            com.pulumi.azurenative.workloads.kotlin.outputs.ThreeTierConfigurationResponse.Companion.toKotlin(args0)
                        })
                    },
                )
            }).orElse(null),
            osSapConfiguration = javaType.osSapConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.OsSapConfigurationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            softwareConfiguration = javaType.softwareConfiguration().map({ args0 -> args0 }).orElse(null),
        )
    }
}
