@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Standard error object.
 * @property code Server-defined set of error codes.
 * @property details Array of details about specific errors that led to this reported error.
 * @property innerError Object containing more specific information than  the current object about the error.
 * @property message Human-readable representation of the error.
 * @property target Target of the error.
 */
public data class ErrorResponse(
    public val code: String,
    public val details: List<ErrorResponse>,
    public val innerError: ErrorResponseInnerError,
    public val message: String,
    public val target: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.ErrorResponse):
            ErrorResponse = ErrorResponse(
            code = javaType.code(),
            details = javaType.details().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.ErrorResponse.Companion.toKotlin(args0)
                })
            }),
            innerError = javaType.innerError().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.ErrorResponseInnerError.Companion.toKotlin(args0)
            }),
            message = javaType.message(),
            target = javaType.target(),
        )
    }
}
