@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Existing recovery services vault.
 * @property id The resource ID of the recovery services vault that has been created.
 * @property vaultType The vault type, whether it is existing or has to be created.
 * Expected value is 'Existing'.
 */
public data class ExistingRecoveryServicesVaultResponse(
    public val id: String,
    public val vaultType: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.ExistingRecoveryServicesVaultResponse):
            ExistingRecoveryServicesVaultResponse = ExistingRecoveryServicesVaultResponse(
            id = javaType.id(),
            vaultType = javaType.vaultType(),
        )
    }
}
