@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * configuration associated with SAP Landscape Monitor Dashboard.
 * @property grouping Gets or sets the SID groupings by landscape and Environment.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property name The name of the resource
 * @property provisioningState State of provisioning of the SAP monitor.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property topMetricsThresholds Gets or sets the list Top Metric Thresholds for SAP Landscape Monitor Dashboard
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetSapLandscapeMonitorResult(
    public val grouping: SapLandscapeMonitorPropertiesResponseGrouping? = null,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val topMetricsThresholds: List<SapLandscapeMonitorMetricThresholdsResponse>? = null,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.GetSapLandscapeMonitorResult):
            GetSapLandscapeMonitorResult = GetSapLandscapeMonitorResult(
            grouping = javaType.grouping().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.SapLandscapeMonitorPropertiesResponseGrouping.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            topMetricsThresholds = javaType.topMetricsThresholds().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.SapLandscapeMonitorMetricThresholdsResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
        )
    }
}
