@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress

/**
 * Define the Server Instance resource.
 * @property configurationData Configuration data for this server instance.
 * @property errors Defines the errors related to SAP Instance resource.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property instanceSid This is the Instance SID for ASCS/AP/DB instance.  An SAP system with HANA database for example could have a different SID for database Instance than that of ASCS instance.
 * @property name The name of the resource
 * @property operatingSystem This is Operating System on which the host server is running.
 * @property performanceData Configuration data for this server instance.
 * @property provisioningState Defines the provisioning states.
 * @property sapInstanceType Defines the type SAP instance on this server instance.
 * @property sapProduct This is the SAP Application Component; e.g. SAP S/4HANA 2022, SAP ERP ENHANCE PACKAGE.
 * @property sapProductVersion Provide the product version of the SAP product.
 * @property serverName This is the Virtual Machine Name of the SAP system. Add all the virtual machines attached to an SAP system which you wish to migrate to Azure. Keeping this not equal to ID as for single tier all InstanceTypes would be on same server, leading to multiple resources with same servername.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetServerInstanceResult(
    public val configurationData: ConfigurationDataResponse,
    public val errors: SAPMigrateErrorResponse,
    public val id: String,
    public val instanceSid: String,
    public val name: String,
    public val operatingSystem: String,
    public val performanceData: Either<ExcelPerformanceDataResponse, NativePerformanceDataResponse>,
    public val provisioningState: String,
    public val sapInstanceType: String,
    public val sapProduct: String,
    public val sapProductVersion: String,
    public val serverName: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.GetServerInstanceResult):
            GetServerInstanceResult = GetServerInstanceResult(
            configurationData = javaType.configurationData().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.ConfigurationDataResponse.Companion.toKotlin(args0)
            }),
            errors = javaType.errors().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.SAPMigrateErrorResponse.Companion.toKotlin(args0)
            }),
            id = javaType.id(),
            instanceSid = javaType.instanceSid(),
            name = javaType.name(),
            operatingSystem = javaType.operatingSystem(),
            performanceData = javaType.performanceData().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.workloads.kotlin.outputs.ExcelPerformanceDataResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.workloads.kotlin.outputs.NativePerformanceDataResponse.Companion.toKotlin(args0)
                    })
                },
            ),
            provisioningState = javaType.provisioningState(),
            sapInstanceType = javaType.sapInstanceType(),
            sapProduct = javaType.sapProduct(),
            sapProductVersion = javaType.sapProductVersion(),
            serverName = javaType.serverName(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
