@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Common settings field for backup management
 * @property isCompression Workload compression flag. This has been added so that 'isSqlCompression'
 * will be deprecated once clients upgrade to consider this flag.
 * @property issqlcompression SQL compression flag
 * @property timeZone TimeZone optional input as string. For example: TimeZone = "Pacific Standard Time".
 */
public data class SettingsResponse(
    public val isCompression: Boolean? = null,
    public val issqlcompression: Boolean? = null,
    public val timeZone: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.SettingsResponse):
            SettingsResponse = SettingsResponse(
            isCompression = javaType.isCompression().map({ args0 -> args0 }).orElse(null),
            issqlcompression = javaType.issqlcompression().map({ args0 -> args0 }).orElse(null),
            timeZone = javaType.timeZone().map({ args0 -> args0 }).orElse(null),
        )
    }
}
