@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * SSH configuration for Linux based VMs running on Azure
 * @property publicKeys The list of SSH public keys used to authenticate with linux based VMs.
 */
public data class SshConfigurationResponse(
    public val publicKeys: List<SshPublicKeyResponse>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.SshConfigurationResponse):
            SshConfigurationResponse = SshConfigurationResponse(
            publicKeys = javaType.publicKeys().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.SshPublicKeyResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
