@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The SSH Key-pair used to authenticate with the VM. The key needs to be at least 2048-bit and in ssh-rsa format. <br><br> For creating ssh keys, see [Create SSH keys on Linux and Mac for Linux VMs in Azure](https://docs.microsoft.com/azure/virtual-machines/linux/create-ssh-keys-detailed).
 * @property privateKey SSH private key.
 * @property publicKey SSH public key
 */
public data class SshKeyPairResponse(
    public val privateKey: String? = null,
    public val publicKey: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.SshKeyPairResponse):
            SshKeyPairResponse = SshKeyPairResponse(
            privateKey = javaType.privateKey().map({ args0 -> args0 }).orElse(null),
            publicKey = javaType.publicKey().map({ args0 -> args0 }).orElse(null),
        )
    }
}
