@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import com.pulumi.core.Either
import kotlin.String
import kotlin.Suppress

/**
 * Defines the VM Backup data for a virtual instance for SAP.
 * @property backupPolicy Defines the policy properties for virtual machine backup.
 * @property backupType The type of backup, VM, SQL or HANA.
 * Expected value is 'VM'.
 * @property diskExclusionProperties Defines the disk exclusion properties for virtual machine backup.
 * @property recoveryServicesVault The properties of the recovery services vault used for backup.
 */
public data class VMBackupDataResponse(
    public val backupPolicy: VMBackupPolicyPropertiesResponse,
    public val backupType: String,
    public val diskExclusionProperties: DiskExclusionPropertiesResponse? = null,
    public val recoveryServicesVault:
    Either<ExistingRecoveryServicesVaultResponse, NewRecoveryServicesVaultResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.VMBackupDataResponse):
            VMBackupDataResponse = VMBackupDataResponse(
            backupPolicy = javaType.backupPolicy().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.VMBackupPolicyPropertiesResponse.Companion.toKotlin(args0)
            }),
            backupType = javaType.backupType(),
            diskExclusionProperties = javaType.diskExclusionProperties().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.DiskExclusionPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            recoveryServicesVault = javaType.recoveryServicesVault().transform(
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.workloads.kotlin.outputs.ExistingRecoveryServicesVaultResponse.Companion.toKotlin(args0)
                    })
                },
                { args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.workloads.kotlin.outputs.NewRecoveryServicesVaultResponse.Companion.toKotlin(args0)
                    })
                },
            ),
        )
    }
}
