@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines the virtual machine configuration.
 * @property imageReference The image reference.
 * @property osProfile The OS profile.
 * @property vmSize The virtual machine size.
 */
public data class VirtualMachineConfigurationResponse(
    public val imageReference: ImageReferenceResponse,
    public val osProfile: OSProfileResponse,
    public val vmSize: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.VirtualMachineConfigurationResponse):
            VirtualMachineConfigurationResponse = VirtualMachineConfigurationResponse(
            imageReference = javaType.imageReference().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.ImageReferenceResponse.Companion.toKotlin(args0)
            }),
            osProfile = javaType.osProfile().let({ args0 ->
                com.pulumi.azurenative.workloads.kotlin.outputs.OSProfileResponse.Companion.toKotlin(args0)
            }),
            vmSize = javaType.vmSize(),
        )
    }
}
