@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.workloads.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * The resource names object for virtual machine and related resources.
 * @property dataDiskNames The full resource names for virtual machine data disks. This is a dictionary containing list of names of data disks per volume. Currently supported volumes for database layer are ['hana/data', 'hana/log', hana/shared', 'usr/sap', 'os', 'backup']. For application and cs layers, only 'default' volume is supported
 * @property hostName The full name for virtual-machine's host (computer name). Currently, ACSS only supports host names which are less than or equal to 13 characters long. If this value is not provided, vmName will be used as host name.
 * @property networkInterfaces The list of network interface name objects for the selected virtual machine. Currently, only one network interface is supported per virtual machine.
 * @property osDiskName The full name for OS disk attached to the VM. If this value is not provided, it will be named by ARM as per its default naming standards (prefixed with vm name). There is only one OS disk attached per Virtual Machine.
 * @property vmName The full name for virtual machine. The length of this field can be upto 64 characters. If name is not provided, service uses a default name based on the deployment type. For SingleServer, default name is {SID}vm. In case of HA-AvZone systems, default name will be {SID}{app/ascs/db}z{a/b}vm with an incrementor at the end in case of more than 1 vm per layer. For distributed and HA-AvSet systems, default name will be {SID}{app/ascs/db}vm with an incrementor at the end in case of more than 1 vm per layer.
 */
public data class VirtualMachineResourceNamesResponse(
    public val dataDiskNames: Map<String, List<String>>? = null,
    public val hostName: String? = null,
    public val networkInterfaces: List<NetworkInterfaceResourceNamesResponse>? = null,
    public val osDiskName: String? = null,
    public val vmName: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.workloads.outputs.VirtualMachineResourceNamesResponse):
            VirtualMachineResourceNamesResponse = VirtualMachineResourceNamesResponse(
            dataDiskNames = javaType.dataDiskNames().map({ args0 ->
                args0.key.to(
                    args0.value.map({ args0 ->
                        args0
                    }),
                )
            }).toMap(),
            hostName = javaType.hostName().map({ args0 -> args0 }).orElse(null),
            networkInterfaces = javaType.networkInterfaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.workloads.kotlin.outputs.NetworkInterfaceResourceNamesResponse.Companion.toKotlin(args0)
                })
            }),
            osDiskName = javaType.osDiskName().map({ args0 -> args0 }).orElse(null),
            vmName = javaType.vmName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
