@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin

import com.pulumi.azurenative.aad.kotlin.outputs.ContainerAccountResponse
import com.pulumi.azurenative.aad.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.aad.kotlin.outputs.ContainerAccountResponse.Companion.toKotlin as containerAccountResponseToKotlin
import com.pulumi.azurenative.aad.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [OuContainer].
 */
@PulumiTagMarker
public class OuContainerResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OuContainerArgs = OuContainerArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OuContainerArgsBuilder.() -> Unit) {
        val builder = OuContainerArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): OuContainer {
        val builtJavaResource = com.pulumi.azurenative.aad.OuContainer(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OuContainer(builtJavaResource)
    }
}

/**
 * Resource for OuContainer.
 * Azure REST API version: 2022-12-01. Prior API version in Azure Native 1.x: 2021-03-01.
 * ## Example Usage
 * ### Create Domain Service
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var ouContainer = new AzureNative.Aad.OuContainer("ouContainer", new()
 *     {
 *         AccountName = "AccountName1",
 *         DomainServiceName = "OuContainer.com",
 *         OuContainerName = "OuContainer1",
 *         Password = "<password>",
 *         ResourceGroupName = "OuContainerResourceGroup",
 *         Spn = "Spn1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/aad/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := aad.NewOuContainer(ctx, "ouContainer", &aad.OuContainerArgs{
 * 			AccountName:       pulumi.String("AccountName1"),
 * 			DomainServiceName: pulumi.String("OuContainer.com"),
 * 			OuContainerName:   pulumi.String("OuContainer1"),
 * 			Password:          pulumi.String("<password>"),
 * 			ResourceGroupName: pulumi.String("OuContainerResourceGroup"),
 * 			Spn:               pulumi.String("Spn1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.aad.OuContainer;
 * import com.pulumi.azurenative.aad.OuContainerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var ouContainer = new OuContainer("ouContainer", OuContainerArgs.builder()
 *             .accountName("AccountName1")
 *             .domainServiceName("OuContainer.com")
 *             .ouContainerName("OuContainer1")
 *             .password("<password>")
 *             .resourceGroupName("OuContainerResourceGroup")
 *             .spn("Spn1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:aad:OuContainer OuContainer.com/OuContainer1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Aad/domainServices/{domainServiceName}/ouContainer/{ouContainerName}
 * ```
 */
public class OuContainer internal constructor(
    override val javaResource: com.pulumi.azurenative.aad.OuContainer,
) : KotlinCustomResource(javaResource, OuContainerMapper) {
    /**
     * The list of container accounts
     */
    public val accounts: Output<List<ContainerAccountResponse>>?
        get() = javaResource.accounts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> containerAccountResponseToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The OuContainer name
     */
    public val containerId: Output<String>
        get() = javaResource.containerId().applyValue({ args0 -> args0 })

    /**
     * The Deployment id
     */
    public val deploymentId: Output<String>
        get() = javaResource.deploymentId().applyValue({ args0 -> args0 })

    /**
     * Distinguished Name of OuContainer instance
     */
    public val distinguishedName: Output<String>
        get() = javaResource.distinguishedName().applyValue({ args0 -> args0 })

    /**
     * The domain name of Domain Services.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * Resource etag
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource location
     */
    public val location: Output<String>?
        get() = javaResource.location().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource name
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The current deployment or provisioning state, which only appears in the response.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * Status of OuContainer instance
     */
    public val serviceStatus: Output<String>
        get() = javaResource.serviceStatus().applyValue({ args0 -> args0 })

    /**
     * The system meta data relating to this resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Azure Active Directory tenant id
     */
    public val tenantId: Output<String>
        get() = javaResource.tenantId().applyValue({ args0 -> args0 })

    /**
     * Resource type
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object OuContainerMapper : ResourceMapper<OuContainer> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.aad.OuContainer::class == javaResource::class

    override fun map(javaResource: Resource): OuContainer = OuContainer(
        javaResource as
            com.pulumi.azurenative.aad.OuContainer,
    )
}

/**
 * @see [OuContainer].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OuContainer].
 */
public suspend fun ouContainer(name: String, block: suspend OuContainerResourceBuilder.() -> Unit): OuContainer {
    val builder = OuContainerResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OuContainer].
 * @param name The _unique_ name of the resulting resource.
 */
public fun ouContainer(name: String): OuContainer {
    val builder = OuContainerResourceBuilder()
    builder.name(name)
    return builder.build()
}
