@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.inputs

import com.pulumi.azurenative.aad.inputs.NotificationSettingsArgs.builder
import com.pulumi.azurenative.aad.kotlin.enums.NotifyDcAdmins
import com.pulumi.azurenative.aad.kotlin.enums.NotifyGlobalAdmins
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Settings for notification
 * @property additionalRecipients The list of additional recipients
 * @property notifyDcAdmins Should domain controller admins be notified
 * @property notifyGlobalAdmins Should global admins be notified
 */
public data class NotificationSettingsArgs(
    public val additionalRecipients: Output<List<String>>? = null,
    public val notifyDcAdmins: Output<Either<String, NotifyDcAdmins>>? = null,
    public val notifyGlobalAdmins: Output<Either<String, NotifyGlobalAdmins>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.aad.inputs.NotificationSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.aad.inputs.NotificationSettingsArgs =
        com.pulumi.azurenative.aad.inputs.NotificationSettingsArgs.builder()
            .additionalRecipients(additionalRecipients?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .notifyDcAdmins(
                notifyDcAdmins?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .notifyGlobalAdmins(
                notifyGlobalAdmins?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            ).build()
}

/**
 * Builder for [NotificationSettingsArgs].
 */
@PulumiTagMarker
public class NotificationSettingsArgsBuilder internal constructor() {
    private var additionalRecipients: Output<List<String>>? = null

    private var notifyDcAdmins: Output<Either<String, NotifyDcAdmins>>? = null

    private var notifyGlobalAdmins: Output<Either<String, NotifyGlobalAdmins>>? = null

    /**
     * @param value The list of additional recipients
     */
    @JvmName("dbytphlpfvntqlwg")
    public suspend fun additionalRecipients(`value`: Output<List<String>>) {
        this.additionalRecipients = value
    }

    @JvmName("cuixguyemwkbswdh")
    public suspend fun additionalRecipients(vararg values: Output<String>) {
        this.additionalRecipients = Output.all(values.asList())
    }

    /**
     * @param values The list of additional recipients
     */
    @JvmName("btighgbmmiavtdgh")
    public suspend fun additionalRecipients(values: List<Output<String>>) {
        this.additionalRecipients = Output.all(values)
    }

    /**
     * @param value Should domain controller admins be notified
     */
    @JvmName("rwitugqejpdrjsiy")
    public suspend fun notifyDcAdmins(`value`: Output<Either<String, NotifyDcAdmins>>) {
        this.notifyDcAdmins = value
    }

    /**
     * @param value Should global admins be notified
     */
    @JvmName("voksjcaocumyqbal")
    public suspend fun notifyGlobalAdmins(`value`: Output<Either<String, NotifyGlobalAdmins>>) {
        this.notifyGlobalAdmins = value
    }

    /**
     * @param value The list of additional recipients
     */
    @JvmName("domjwhwvpmtkeltp")
    public suspend fun additionalRecipients(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalRecipients = mapped
    }

    /**
     * @param values The list of additional recipients
     */
    @JvmName("ugfwncekwsxmnjhf")
    public suspend fun additionalRecipients(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.additionalRecipients = mapped
    }

    /**
     * @param value Should domain controller admins be notified
     */
    @JvmName("ichgvnacfflrudsp")
    public suspend fun notifyDcAdmins(`value`: Either<String, NotifyDcAdmins>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notifyDcAdmins = mapped
    }

    /**
     * @param value Should domain controller admins be notified
     */
    @JvmName("ftvrmdsjrfnmfjsl")
    public fun notifyDcAdmins(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NotifyDcAdmins>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notifyDcAdmins = mapped
    }

    /**
     * @param value Should domain controller admins be notified
     */
    @JvmName("uesswyyiaejwswdi")
    public fun notifyDcAdmins(`value`: NotifyDcAdmins) {
        val toBeMapped = Either.ofRight<String, NotifyDcAdmins>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notifyDcAdmins = mapped
    }

    /**
     * @param value Should global admins be notified
     */
    @JvmName("svcuvvmyceprpdmg")
    public suspend fun notifyGlobalAdmins(`value`: Either<String, NotifyGlobalAdmins>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.notifyGlobalAdmins = mapped
    }

    /**
     * @param value Should global admins be notified
     */
    @JvmName("queuihiabgvmjhww")
    public fun notifyGlobalAdmins(`value`: String) {
        val toBeMapped = Either.ofLeft<String, NotifyGlobalAdmins>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notifyGlobalAdmins = mapped
    }

    /**
     * @param value Should global admins be notified
     */
    @JvmName("tpeobwknaobuxfor")
    public fun notifyGlobalAdmins(`value`: NotifyGlobalAdmins) {
        val toBeMapped = Either.ofRight<String, NotifyGlobalAdmins>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.notifyGlobalAdmins = mapped
    }

    internal fun build(): NotificationSettingsArgs = NotificationSettingsArgs(
        additionalRecipients = additionalRecipients,
        notifyDcAdmins = notifyDcAdmins,
        notifyGlobalAdmins = notifyGlobalAdmins,
    )
}
