@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Configuration Diagnostics
 * @property lastExecuted Last domain configuration diagnostics DateTime
 * @property validatorResults List of Configuration Diagnostics validator results.
 */
public data class ConfigDiagnosticsResponse(
    public val lastExecuted: String? = null,
    public val validatorResults: List<ConfigDiagnosticsValidatorResultResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.aad.outputs.ConfigDiagnosticsResponse): ConfigDiagnosticsResponse = ConfigDiagnosticsResponse(
            lastExecuted = javaType.lastExecuted().map({ args0 -> args0 }).orElse(null),
            validatorResults = javaType.validatorResults().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.aad.kotlin.outputs.ConfigDiagnosticsValidatorResultResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
