@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Specific issue for a particular config diagnostics validator
 * @property descriptionParams List of domain resource property name or values used to compose a rich description.
 * @property id Validation issue identifier.
 */
public data class ConfigDiagnosticsValidatorResultIssueResponse(
    public val descriptionParams: List<String>? = null,
    public val id: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.aad.outputs.ConfigDiagnosticsValidatorResultIssueResponse): ConfigDiagnosticsValidatorResultIssueResponse =
            ConfigDiagnosticsValidatorResultIssueResponse(
                descriptionParams = javaType.descriptionParams().map({ args0 -> args0 }),
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
            )
    }
}
