@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Config Diagnostics validator result data
 * @property issues List of resource config validation issues.
 * @property replicaSetSubnetDisplayName Replica set location and subnet name
 * @property status Status for individual validator after running diagnostics.
 * @property validatorId Validator identifier
 */
public data class ConfigDiagnosticsValidatorResultResponse(
    public val issues: List<ConfigDiagnosticsValidatorResultIssueResponse>? = null,
    public val replicaSetSubnetDisplayName: String? = null,
    public val status: String? = null,
    public val validatorId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.aad.outputs.ConfigDiagnosticsValidatorResultResponse): ConfigDiagnosticsValidatorResultResponse = ConfigDiagnosticsValidatorResultResponse(
            issues = javaType.issues().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.aad.kotlin.outputs.ConfigDiagnosticsValidatorResultIssueResponse.Companion.toKotlin(args0)
                })
            }),
            replicaSetSubnetDisplayName = javaType.replicaSetSubnetDisplayName().map({ args0 ->
                args0
            }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            validatorId = javaType.validatorId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
