@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Domain Security Settings
 * @property channelBinding A flag to determine whether or not ChannelBinding is enabled or disabled.
 * @property kerberosArmoring A flag to determine whether or not KerberosArmoring is enabled or disabled.
 * @property kerberosRc4Encryption A flag to determine whether or not KerberosRc4Encryption is enabled or disabled.
 * @property ldapSigning A flag to determine whether or not LdapSigning is enabled or disabled.
 * @property ntlmV1 A flag to determine whether or not NtlmV1 is enabled or disabled.
 * @property syncKerberosPasswords A flag to determine whether or not SyncKerberosPasswords is enabled or disabled.
 * @property syncNtlmPasswords A flag to determine whether or not SyncNtlmPasswords is enabled or disabled.
 * @property syncOnPremPasswords A flag to determine whether or not SyncOnPremPasswords is enabled or disabled.
 * @property tlsV1 A flag to determine whether or not TlsV1 is enabled or disabled.
 */
public data class DomainSecuritySettingsResponse(
    public val channelBinding: String? = null,
    public val kerberosArmoring: String? = null,
    public val kerberosRc4Encryption: String? = null,
    public val ldapSigning: String? = null,
    public val ntlmV1: String? = null,
    public val syncKerberosPasswords: String? = null,
    public val syncNtlmPasswords: String? = null,
    public val syncOnPremPasswords: String? = null,
    public val tlsV1: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.aad.outputs.DomainSecuritySettingsResponse): DomainSecuritySettingsResponse = DomainSecuritySettingsResponse(
            channelBinding = javaType.channelBinding().map({ args0 -> args0 }).orElse(null),
            kerberosArmoring = javaType.kerberosArmoring().map({ args0 -> args0 }).orElse(null),
            kerberosRc4Encryption = javaType.kerberosRc4Encryption().map({ args0 -> args0 }).orElse(null),
            ldapSigning = javaType.ldapSigning().map({ args0 -> args0 }).orElse(null),
            ntlmV1 = javaType.ntlmV1().map({ args0 -> args0 }).orElse(null),
            syncKerberosPasswords = javaType.syncKerberosPasswords().map({ args0 -> args0 }).orElse(null),
            syncNtlmPasswords = javaType.syncNtlmPasswords().map({ args0 -> args0 }).orElse(null),
            syncOnPremPasswords = javaType.syncOnPremPasswords().map({ args0 -> args0 }).orElse(null),
            tlsV1 = javaType.tlsV1().map({ args0 -> args0 }).orElse(null),
        )
    }
}
