@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Forest Trust Setting
 * @property friendlyName Friendly Name
 * @property remoteDnsIps Remote Dns ips
 * @property trustDirection Trust Direction
 * @property trustPassword Trust Password
 * @property trustedDomainFqdn Trusted Domain FQDN
 */
public data class ForestTrustResponse(
    public val friendlyName: String? = null,
    public val remoteDnsIps: String? = null,
    public val trustDirection: String? = null,
    public val trustPassword: String? = null,
    public val trustedDomainFqdn: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.aad.outputs.ForestTrustResponse): ForestTrustResponse = ForestTrustResponse(
            friendlyName = javaType.friendlyName().map({ args0 -> args0 }).orElse(null),
            remoteDnsIps = javaType.remoteDnsIps().map({ args0 -> args0 }).orElse(null),
            trustDirection = javaType.trustDirection().map({ args0 -> args0 }).orElse(null),
            trustPassword = javaType.trustPassword().map({ args0 -> args0 }).orElse(null),
            trustedDomainFqdn = javaType.trustedDomainFqdn().map({ args0 -> args0 }).orElse(null),
        )
    }
}
