@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Domain service.
 * @property configDiagnostics Configuration diagnostics data containing latest execution from client.
 * @property deploymentId Deployment Id
 * @property domainConfigurationType Domain Configuration Type
 * @property domainName The name of the Azure domain that the user would like to deploy Domain Services to.
 * @property domainSecuritySettings DomainSecurity Settings
 * @property etag Resource etag
 * @property filteredSync Enabled or Disabled flag to turn on Group-based filtered sync
 * @property id Resource Id
 * @property ldapsSettings Secure LDAP Settings
 * @property location Resource location
 * @property migrationProperties Migration Properties
 * @property name Resource name
 * @property notificationSettings Notification Settings
 * @property provisioningState the current deployment or provisioning state, which only appears in the response.
 * @property replicaSets List of ReplicaSets
 * @property resourceForestSettings Resource Forest Settings
 * @property sku Sku Type
 * @property syncApplicationId The unique sync application id of the Azure AD Domain Services deployment.
 * @property syncOwner SyncOwner ReplicaSet Id
 * @property syncScope All or CloudOnly, All users in AAD are synced to AAD DS domain or only users actively syncing in the cloud
 * @property systemData The system meta data relating to this resource.
 * @property tags Resource tags
 * @property tenantId Azure Active Directory Tenant Id
 * @property type Resource type
 * @property version Data Model Version
 */
public data class GetDomainServiceResult(
    public val configDiagnostics: ConfigDiagnosticsResponse? = null,
    public val deploymentId: String,
    public val domainConfigurationType: String? = null,
    public val domainName: String? = null,
    public val domainSecuritySettings: DomainSecuritySettingsResponse? = null,
    public val etag: String? = null,
    public val filteredSync: String? = null,
    public val id: String,
    public val ldapsSettings: LdapsSettingsResponse? = null,
    public val location: String? = null,
    public val migrationProperties: MigrationPropertiesResponse,
    public val name: String,
    public val notificationSettings: NotificationSettingsResponse? = null,
    public val provisioningState: String,
    public val replicaSets: List<ReplicaSetResponse>? = null,
    public val resourceForestSettings: ResourceForestSettingsResponse? = null,
    public val sku: String? = null,
    public val syncApplicationId: String,
    public val syncOwner: String,
    public val syncScope: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val tenantId: String,
    public val type: String,
    public val version: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.aad.outputs.GetDomainServiceResult): GetDomainServiceResult = GetDomainServiceResult(
            configDiagnostics = javaType.configDiagnostics().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.aad.kotlin.outputs.ConfigDiagnosticsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            deploymentId = javaType.deploymentId(),
            domainConfigurationType = javaType.domainConfigurationType().map({ args0 -> args0 }).orElse(null),
            domainName = javaType.domainName().map({ args0 -> args0 }).orElse(null),
            domainSecuritySettings = javaType.domainSecuritySettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.aad.kotlin.outputs.DomainSecuritySettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            filteredSync = javaType.filteredSync().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ldapsSettings = javaType.ldapsSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.aad.kotlin.outputs.LdapsSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            migrationProperties = javaType.migrationProperties().let({ args0 ->
                com.pulumi.azurenative.aad.kotlin.outputs.MigrationPropertiesResponse.Companion.toKotlin(args0)
            }),
            name = javaType.name(),
            notificationSettings = javaType.notificationSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.aad.kotlin.outputs.NotificationSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            replicaSets = javaType.replicaSets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.aad.kotlin.outputs.ReplicaSetResponse.Companion.toKotlin(args0)
                })
            }),
            resourceForestSettings = javaType.resourceForestSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.aad.kotlin.outputs.ResourceForestSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sku = javaType.sku().map({ args0 -> args0 }).orElse(null),
            syncApplicationId = javaType.syncApplicationId(),
            syncOwner = javaType.syncOwner(),
            syncScope = javaType.syncScope().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.aad.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tenantId = javaType.tenantId(),
            type = javaType.type(),
            version = javaType.version(),
        )
    }
}
