@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Resource for OuContainer.
 * @property accounts The list of container accounts
 * @property containerId The OuContainer name
 * @property deploymentId The Deployment id
 * @property distinguishedName Distinguished Name of OuContainer instance
 * @property domainName The domain name of Domain Services.
 * @property etag Resource etag
 * @property id Resource Id
 * @property location Resource location
 * @property name Resource name
 * @property provisioningState The current deployment or provisioning state, which only appears in the response.
 * @property serviceStatus Status of OuContainer instance
 * @property systemData The system meta data relating to this resource.
 * @property tags Resource tags
 * @property tenantId Azure Active Directory tenant id
 * @property type Resource type
 */
public data class GetOuContainerResult(
    public val accounts: List<ContainerAccountResponse>? = null,
    public val containerId: String,
    public val deploymentId: String,
    public val distinguishedName: String,
    public val domainName: String,
    public val etag: String? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val serviceStatus: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val tenantId: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.aad.outputs.GetOuContainerResult): GetOuContainerResult = GetOuContainerResult(
            accounts = javaType.accounts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.aad.kotlin.outputs.ContainerAccountResponse.Companion.toKotlin(args0)
                })
            }),
            containerId = javaType.containerId(),
            deploymentId = javaType.deploymentId(),
            distinguishedName = javaType.distinguishedName(),
            domainName = javaType.domainName(),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            serviceStatus = javaType.serviceStatus(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.aad.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tenantId = javaType.tenantId(),
            type = javaType.type(),
        )
    }
}
