@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Health Alert Description
 * @property id Health Alert Id
 * @property issue Health Alert Issue
 * @property lastDetected Health Alert Last Detected DateTime
 * @property name Health Alert Name
 * @property raised Health Alert Raised DateTime
 * @property resolutionUri Health Alert TSG Link
 * @property severity Health Alert Severity
 */
public data class HealthAlertResponse(
    public val id: String,
    public val issue: String,
    public val lastDetected: String,
    public val name: String,
    public val raised: String,
    public val resolutionUri: String,
    public val severity: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.aad.outputs.HealthAlertResponse): HealthAlertResponse = HealthAlertResponse(
            id = javaType.id(),
            issue = javaType.issue(),
            lastDetected = javaType.lastDetected(),
            name = javaType.name(),
            raised = javaType.raised(),
            resolutionUri = javaType.resolutionUri(),
            severity = javaType.severity(),
        )
    }
}
