@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Secure LDAP Settings
 * @property certificateNotAfter NotAfter DateTime of configure ldaps certificate.
 * @property certificateThumbprint Thumbprint of configure ldaps certificate.
 * @property externalAccess A flag to determine whether or not Secure LDAP access over the internet is enabled or disabled.
 * @property ldaps A flag to determine whether or not Secure LDAP is enabled or disabled.
 * @property pfxCertificate The certificate required to configure Secure LDAP. The parameter passed here should be a base64encoded representation of the certificate pfx file.
 * @property pfxCertificatePassword The password to decrypt the provided Secure LDAP certificate pfx file.
 * @property publicCertificate Public certificate used to configure secure ldap.
 */
public data class LdapsSettingsResponse(
    public val certificateNotAfter: String,
    public val certificateThumbprint: String,
    public val externalAccess: String? = null,
    public val ldaps: String? = null,
    public val pfxCertificate: String? = null,
    public val pfxCertificatePassword: String? = null,
    public val publicCertificate: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.aad.outputs.LdapsSettingsResponse): LdapsSettingsResponse = LdapsSettingsResponse(
            certificateNotAfter = javaType.certificateNotAfter(),
            certificateThumbprint = javaType.certificateThumbprint(),
            externalAccess = javaType.externalAccess().map({ args0 -> args0 }).orElse(null),
            ldaps = javaType.ldaps().map({ args0 -> args0 }).orElse(null),
            pfxCertificate = javaType.pfxCertificate().map({ args0 -> args0 }).orElse(null),
            pfxCertificatePassword = javaType.pfxCertificatePassword().map({ args0 -> args0 }).orElse(null),
            publicCertificate = javaType.publicCertificate(),
        )
    }
}
