@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Settings for notification
 * @property additionalRecipients The list of additional recipients
 * @property notifyDcAdmins Should domain controller admins be notified
 * @property notifyGlobalAdmins Should global admins be notified
 */
public data class NotificationSettingsResponse(
    public val additionalRecipients: List<String>? = null,
    public val notifyDcAdmins: String? = null,
    public val notifyGlobalAdmins: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.aad.outputs.NotificationSettingsResponse): NotificationSettingsResponse = NotificationSettingsResponse(
            additionalRecipients = javaType.additionalRecipients().map({ args0 -> args0 }),
            notifyDcAdmins = javaType.notifyDcAdmins().map({ args0 -> args0 }).orElse(null),
            notifyGlobalAdmins = javaType.notifyGlobalAdmins().map({ args0 -> args0 }).orElse(null),
        )
    }
}
