@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Replica Set Definition
 * @property domainControllerIpAddress List of Domain Controller IP Address
 * @property externalAccessIpAddress External access ip address.
 * @property healthAlerts List of Domain Health Alerts
 * @property healthLastEvaluated Last domain evaluation run DateTime
 * @property healthMonitors List of Domain Health Monitors
 * @property location Virtual network location
 * @property replicaSetId ReplicaSet Id
 * @property serviceStatus Status of Domain Service instance
 * @property subnetId The name of the virtual network that Domain Services will be deployed on. The id of the subnet that Domain Services will be deployed on. /virtualNetwork/vnetName/subnets/subnetName.
 * @property vnetSiteId Virtual network site id
 */
public data class ReplicaSetResponse(
    public val domainControllerIpAddress: List<String>,
    public val externalAccessIpAddress: String,
    public val healthAlerts: List<HealthAlertResponse>,
    public val healthLastEvaluated: String,
    public val healthMonitors: List<HealthMonitorResponse>,
    public val location: String? = null,
    public val replicaSetId: String,
    public val serviceStatus: String,
    public val subnetId: String? = null,
    public val vnetSiteId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.aad.outputs.ReplicaSetResponse): ReplicaSetResponse = ReplicaSetResponse(
            domainControllerIpAddress = javaType.domainControllerIpAddress().map({ args0 -> args0 }),
            externalAccessIpAddress = javaType.externalAccessIpAddress(),
            healthAlerts = javaType.healthAlerts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.aad.kotlin.outputs.HealthAlertResponse.Companion.toKotlin(args0)
                })
            }),
            healthLastEvaluated = javaType.healthLastEvaluated(),
            healthMonitors = javaType.healthMonitors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.aad.kotlin.outputs.HealthMonitorResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            replicaSetId = javaType.replicaSetId(),
            serviceStatus = javaType.serviceStatus(),
            subnetId = javaType.subnetId().map({ args0 -> args0 }).orElse(null),
            vnetSiteId = javaType.vnetSiteId(),
        )
    }
}
