@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aad.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Settings for Resource Forest
 * @property resourceForest Resource Forest
 * @property settings List of settings for Resource Forest
 */
public data class ResourceForestSettingsResponse(
    public val resourceForest: String? = null,
    public val settings: List<ForestTrustResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.aad.outputs.ResourceForestSettingsResponse): ResourceForestSettingsResponse = ResourceForestSettingsResponse(
            resourceForest = javaType.resourceForest().map({ args0 -> args0 }).orElse(null),
            settings = javaType.settings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.aad.kotlin.outputs.ForestTrustResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
