@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aadiam.kotlin

import com.pulumi.azurenative.aadiam.kotlin.outputs.AzureADMetricsPropertiesFormatResponse
import com.pulumi.azurenative.aadiam.kotlin.outputs.AzureADMetricsPropertiesFormatResponse.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [AzureADMetric].
 */
@PulumiTagMarker
public class AzureADMetricResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AzureADMetricArgs = AzureADMetricArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AzureADMetricArgsBuilder.() -> Unit) {
        val builder = AzureADMetricArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AzureADMetric {
        val builtJavaResource = com.pulumi.azurenative.aadiam.AzureADMetric(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AzureADMetric(builtJavaResource)
    }
}

/**
 * AzureADMetrics resource.
 * Azure REST API version: 2020-07-01-preview. Prior API version in Azure Native 1.x: 2020-07-01-preview.
 * ## Example Usage
 * ### azureADMetricsCreate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var azureADMetric = new AzureNative.AadIam.AzureADMetric("azureADMetric", new()
 *     {
 *         AzureADMetricsName = "ddb1",
 *         Location = "West US",
 *         ResourceGroupName = "rg1",
 *         Tags = null,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/aadiam/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := aadiam.NewAzureADMetric(ctx, "azureADMetric", &aadiam.AzureADMetricArgs{
 * 			AzureADMetricsName: pulumi.String("ddb1"),
 * 			Location:           pulumi.String("West US"),
 * 			ResourceGroupName:  pulumi.String("rg1"),
 * 			Tags:               nil,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.aadiam.AzureADMetric;
 * import com.pulumi.azurenative.aadiam.AzureADMetricArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var azureADMetric = new AzureADMetric("azureADMetric", AzureADMetricArgs.builder()
 *             .azureADMetricsName("ddb1")
 *             .location("West US")
 *             .resourceGroupName("rg1")
 *             .tags()
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:aadiam:AzureADMetric ddb1 /subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/providers/microsoft.aadiam/azureADMetrics/{azureADMetricsName}
 * ```
 */
public class AzureADMetric internal constructor(
    override val javaResource: com.pulumi.azurenative.aadiam.AzureADMetric,
) : KotlinCustomResource(javaResource, AzureADMetricMapper) {
    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val properties: Output<AzureADMetricsPropertiesFormatResponse>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object AzureADMetricMapper : ResourceMapper<AzureADMetric> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.aadiam.AzureADMetric::class == javaResource::class

    override fun map(javaResource: Resource): AzureADMetric = AzureADMetric(
        javaResource as
            com.pulumi.azurenative.aadiam.AzureADMetric,
    )
}

/**
 * @see [AzureADMetric].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AzureADMetric].
 */
public suspend fun azureADMetric(
    name: String,
    block: suspend AzureADMetricResourceBuilder.() -> Unit,
): AzureADMetric {
    val builder = AzureADMetricResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AzureADMetric].
 * @param name The _unique_ name of the resulting resource.
 */
public fun azureADMetric(name: String): AzureADMetric {
    val builder = AzureADMetricResourceBuilder()
    builder.name(name)
    return builder.build()
}
