@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aadiam.kotlin.inputs

import com.pulumi.azurenative.aadiam.inputs.GetAzureADMetricPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property azureADMetricsName Name of the azureADMetrics instance.
 * @property resourceGroupName Name of an Azure resource group.
 */
public data class GetAzureADMetricPlainArgs(
    public val azureADMetricsName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.aadiam.inputs.GetAzureADMetricPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.aadiam.inputs.GetAzureADMetricPlainArgs =
        com.pulumi.azurenative.aadiam.inputs.GetAzureADMetricPlainArgs.builder()
            .azureADMetricsName(azureADMetricsName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAzureADMetricPlainArgs].
 */
@PulumiTagMarker
public class GetAzureADMetricPlainArgsBuilder internal constructor() {
    private var azureADMetricsName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the azureADMetrics instance.
     */
    @JvmName("nxbtlltsqhtybcwl")
    public suspend fun azureADMetricsName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.azureADMetricsName = mapped
    }

    /**
     * @param value Name of an Azure resource group.
     */
    @JvmName("ifklbrncgracjogd")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetAzureADMetricPlainArgs = GetAzureADMetricPlainArgs(
        azureADMetricsName = azureADMetricsName ?: throw PulumiNullFieldException("azureADMetricsName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
