@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aadiam.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The diagnostic setting resource.
 * @property eventHubAuthorizationRuleId The resource Id for the event hub authorization rule.
 * @property eventHubName The name of the event hub. If none is specified, the default event hub will be selected.
 * @property id Azure resource Id
 * @property logs The list of logs settings.
 * @property name Azure resource name
 * @property serviceBusRuleId The service bus rule Id of the diagnostic setting. This is here to maintain backwards compatibility.
 * @property storageAccountId The resource ID of the storage account to which you would like to send Diagnostic Logs.
 * @property type Azure resource type
 * @property workspaceId The workspace ID (resource ID of a Log Analytics workspace) for a Log Analytics workspace to which you would like to send Diagnostic Logs. Example: /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2
 */
public data class GetDiagnosticSettingResult(
    public val eventHubAuthorizationRuleId: String? = null,
    public val eventHubName: String? = null,
    public val id: String,
    public val logs: List<LogSettingsResponse>? = null,
    public val name: String,
    public val serviceBusRuleId: String? = null,
    public val storageAccountId: String? = null,
    public val type: String,
    public val workspaceId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.aadiam.outputs.GetDiagnosticSettingResult): GetDiagnosticSettingResult = GetDiagnosticSettingResult(
            eventHubAuthorizationRuleId = javaType.eventHubAuthorizationRuleId().map({ args0 ->
                args0
            }).orElse(null),
            eventHubName = javaType.eventHubName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            logs = javaType.logs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.aadiam.kotlin.outputs.LogSettingsResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name(),
            serviceBusRuleId = javaType.serviceBusRuleId().map({ args0 -> args0 }).orElse(null),
            storageAccountId = javaType.storageAccountId().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
            workspaceId = javaType.workspaceId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
