@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aadiam.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * PrivateLink Policy configuration object.
 * @property allTenants Flag indicating whether all tenants are allowed
 * @property id String Id used to locate any resource on Azure.
 * @property name Name of this resource.
 * @property ownerTenantId Guid of the owner tenant
 * @property resourceGroup Name of the resource group
 * @property resourceName Name of the private link policy resource
 * @property subscriptionId Subscription Identifier
 * @property tags Resource tags.
 * @property tenants The list of tenantIds.
 * @property type Type of this resource.
 */
public data class GetPrivateLinkForAzureAdResult(
    public val allTenants: Boolean? = null,
    public val id: String,
    public val name: String? = null,
    public val ownerTenantId: String? = null,
    public val resourceGroup: String? = null,
    public val resourceName: String? = null,
    public val subscriptionId: String? = null,
    public val tags: Map<String, String>? = null,
    public val tenants: List<String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.aadiam.outputs.GetPrivateLinkForAzureAdResult): GetPrivateLinkForAzureAdResult = GetPrivateLinkForAzureAdResult(
            allTenants = javaType.allTenants().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            ownerTenantId = javaType.ownerTenantId().map({ args0 -> args0 }).orElse(null),
            resourceGroup = javaType.resourceGroup().map({ args0 -> args0 }).orElse(null),
            resourceName = javaType.resourceName().map({ args0 -> args0 }).orElse(null),
            subscriptionId = javaType.subscriptionId().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tenants = javaType.tenants().map({ args0 -> args0 }),
            type = javaType.type(),
        )
    }
}
