@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aadiam.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * Part of MultiTenantDiagnosticSettings. Specifies the settings for a particular log.
 * @property category Name of a Diagnostic Log category for a resource type this setting is applied to. To obtain the list of Diagnostic Log categories for a resource, first perform a GET diagnostic settings operation.
 * @property enabled A value indicating whether this log is enabled.
 * @property retentionPolicy The retention policy for this log.
 */
public data class LogSettingsResponse(
    public val category: String? = null,
    public val enabled: Boolean,
    public val retentionPolicy: RetentionPolicyResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.aadiam.outputs.LogSettingsResponse): LogSettingsResponse = LogSettingsResponse(
            category = javaType.category().map({ args0 -> args0 }).orElse(null),
            enabled = javaType.enabled(),
            retentionPolicy = javaType.retentionPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.aadiam.kotlin.outputs.RetentionPolicyResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
