@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.aadiam.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress

/**
 * Specifies the retention policy for the log.
 * @property days The number of days for the retention in days. A value of 0 will retain the events indefinitely.
 * @property enabled A value indicating whether the retention policy is enabled.
 */
public data class RetentionPolicyResponse(
    public val days: Int,
    public val enabled: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.aadiam.outputs.RetentionPolicyResponse): RetentionPolicyResponse = RetentionPolicyResponse(
            days = javaType.days(),
            enabled = javaType.enabled(),
        )
    }
}
