@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.addons.kotlin.inputs

import com.pulumi.azurenative.addons.inputs.GetSupportPlanTypePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property planTypeName The Canonical support plan type.
 * @property providerName The support plan type. For now the only valid type is "canonical".
 */
public data class GetSupportPlanTypePlainArgs(
    public val planTypeName: String,
    public val providerName: String,
) : ConvertibleToJava<com.pulumi.azurenative.addons.inputs.GetSupportPlanTypePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.addons.inputs.GetSupportPlanTypePlainArgs =
        com.pulumi.azurenative.addons.inputs.GetSupportPlanTypePlainArgs.builder()
            .planTypeName(planTypeName.let({ args0 -> args0 }))
            .providerName(providerName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSupportPlanTypePlainArgs].
 */
@PulumiTagMarker
public class GetSupportPlanTypePlainArgsBuilder internal constructor() {
    private var planTypeName: String? = null

    private var providerName: String? = null

    /**
     * @param value The Canonical support plan type.
     */
    @JvmName("wqdpupvlagrxgcxm")
    public suspend fun planTypeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.planTypeName = mapped
    }

    /**
     * @param value The support plan type. For now the only valid type is "canonical".
     */
    @JvmName("vucdvlmvatfeiiuh")
    public suspend fun providerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.providerName = mapped
    }

    internal fun build(): GetSupportPlanTypePlainArgs = GetSupportPlanTypePlainArgs(
        planTypeName = planTypeName ?: throw PulumiNullFieldException("planTypeName"),
        providerName = providerName ?: throw PulumiNullFieldException("providerName"),
    )
}
