@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.advisor.kotlin

import com.pulumi.azurenative.advisor.AdvisorFunctions.getSuppressionPlain
import com.pulumi.azurenative.advisor.kotlin.inputs.GetSuppressionPlainArgs
import com.pulumi.azurenative.advisor.kotlin.inputs.GetSuppressionPlainArgsBuilder
import com.pulumi.azurenative.advisor.kotlin.outputs.GetSuppressionResult
import com.pulumi.azurenative.advisor.kotlin.outputs.GetSuppressionResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object AdvisorFunctions {
    /**
     * Obtains the details of a suppression.
     * Azure REST API version: 2023-01-01.
     * Other available API versions: 2016-07-12-preview.
     * @param argument null
     * @return The details of the snoozed or dismissed rule; for example, the duration, name, and GUID associated with the rule.
     */
    public suspend fun getSuppression(argument: GetSuppressionPlainArgs): GetSuppressionResult =
        toKotlin(getSuppressionPlain(argument.toJava()).await())

    /**
     * @see [getSuppression].
     * @param name The name of the suppression.
     * @param recommendationId The recommendation ID.
     * @param resourceUri The fully qualified Azure Resource Manager identifier of the resource to which the recommendation applies.
     * @return The details of the snoozed or dismissed rule; for example, the duration, name, and GUID associated with the rule.
     */
    public suspend fun getSuppression(
        name: String,
        recommendationId: String,
        resourceUri: String,
    ): GetSuppressionResult {
        val argument = GetSuppressionPlainArgs(
            name = name,
            recommendationId = recommendationId,
            resourceUri = resourceUri,
        )
        return toKotlin(getSuppressionPlain(argument.toJava()).await())
    }

    /**
     * @see [getSuppression].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;advisor&#46;kotlin&#46;inputs&#46;GetSuppressionPlainArgs].
     * @return The details of the snoozed or dismissed rule; for example, the duration, name, and GUID associated with the rule.
     */
    public suspend fun getSuppression(argument: suspend GetSuppressionPlainArgsBuilder.() -> Unit): GetSuppressionResult {
        val builder = GetSuppressionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getSuppressionPlain(builtArgument.toJava()).await())
    }
}
