@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin

import com.pulumi.azurenative.agfoodplatform.AgfoodplatformFunctions.getDataConnectorPlain
import com.pulumi.azurenative.agfoodplatform.AgfoodplatformFunctions.getDataManagerForAgricultureResourcePlain
import com.pulumi.azurenative.agfoodplatform.AgfoodplatformFunctions.getExtensionPlain
import com.pulumi.azurenative.agfoodplatform.AgfoodplatformFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.agfoodplatform.AgfoodplatformFunctions.getSolutionPlain
import com.pulumi.azurenative.agfoodplatform.kotlin.inputs.GetDataConnectorPlainArgs
import com.pulumi.azurenative.agfoodplatform.kotlin.inputs.GetDataConnectorPlainArgsBuilder
import com.pulumi.azurenative.agfoodplatform.kotlin.inputs.GetDataManagerForAgricultureResourcePlainArgs
import com.pulumi.azurenative.agfoodplatform.kotlin.inputs.GetDataManagerForAgricultureResourcePlainArgsBuilder
import com.pulumi.azurenative.agfoodplatform.kotlin.inputs.GetExtensionPlainArgs
import com.pulumi.azurenative.agfoodplatform.kotlin.inputs.GetExtensionPlainArgsBuilder
import com.pulumi.azurenative.agfoodplatform.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.agfoodplatform.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.agfoodplatform.kotlin.inputs.GetSolutionPlainArgs
import com.pulumi.azurenative.agfoodplatform.kotlin.inputs.GetSolutionPlainArgsBuilder
import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.GetDataConnectorResult
import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.GetDataManagerForAgricultureResourceResult
import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.GetExtensionResult
import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.GetSolutionResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.GetDataConnectorResult.Companion.toKotlin as getDataConnectorResultToKotlin
import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.GetDataManagerForAgricultureResourceResult.Companion.toKotlin as getDataManagerForAgricultureResourceResultToKotlin
import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.GetExtensionResult.Companion.toKotlin as getExtensionResultToKotlin
import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.GetSolutionResult.Companion.toKotlin as getSolutionResultToKotlin

public object AgfoodplatformFunctions {
    /**
     * Get specific Data Connector resource by DataConnectorName.
     * Azure REST API version: 2023-06-01-preview.
     * @param argument null
     * @return DataConnector Model.
     */
    public suspend fun getDataConnector(argument: GetDataConnectorPlainArgs): GetDataConnectorResult =
        getDataConnectorResultToKotlin(getDataConnectorPlain(argument.toJava()).await())

    /**
     * @see [getDataConnector].
     * @param dataConnectorName Connector name.
     * @param dataManagerForAgricultureResourceName DataManagerForAgriculture resource name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return DataConnector Model.
     */
    public suspend fun getDataConnector(
        dataConnectorName: String,
        dataManagerForAgricultureResourceName: String,
        resourceGroupName: String,
    ): GetDataConnectorResult {
        val argument = GetDataConnectorPlainArgs(
            dataConnectorName = dataConnectorName,
            dataManagerForAgricultureResourceName = dataManagerForAgricultureResourceName,
            resourceGroupName = resourceGroupName,
        )
        return getDataConnectorResultToKotlin(getDataConnectorPlain(argument.toJava()).await())
    }

    /**
     * @see [getDataConnector].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;agfoodplatform&#46;kotlin&#46;inputs&#46;GetDataConnectorPlainArgs].
     * @return DataConnector Model.
     */
    public suspend fun getDataConnector(argument: suspend GetDataConnectorPlainArgsBuilder.() -> Unit): GetDataConnectorResult {
        val builder = GetDataConnectorPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataConnectorResultToKotlin(getDataConnectorPlain(builtArgument.toJava()).await())
    }

    /**
     * Get DataManagerForAgriculture resource.
     * Azure REST API version: 2023-06-01-preview.
     * @param argument null
     * @return Data Manager For Agriculture ARM Resource.
     */
    public suspend fun getDataManagerForAgricultureResource(argument: GetDataManagerForAgricultureResourcePlainArgs): GetDataManagerForAgricultureResourceResult =
        getDataManagerForAgricultureResourceResultToKotlin(getDataManagerForAgricultureResourcePlain(argument.toJava()).await())

    /**
     * @see [getDataManagerForAgricultureResource].
     * @param dataManagerForAgricultureResourceName DataManagerForAgriculture resource name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Data Manager For Agriculture ARM Resource.
     */
    public suspend fun getDataManagerForAgricultureResource(
        dataManagerForAgricultureResourceName: String,
        resourceGroupName: String,
    ): GetDataManagerForAgricultureResourceResult {
        val argument = GetDataManagerForAgricultureResourcePlainArgs(
            dataManagerForAgricultureResourceName = dataManagerForAgricultureResourceName,
            resourceGroupName = resourceGroupName,
        )
        return getDataManagerForAgricultureResourceResultToKotlin(getDataManagerForAgricultureResourcePlain(argument.toJava()).await())
    }

    /**
     * @see [getDataManagerForAgricultureResource].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;agfoodplatform&#46;kotlin&#46;inputs&#46;GetDataManagerForAgricultureResourcePlainArgs].
     * @return Data Manager For Agriculture ARM Resource.
     */
    public suspend fun getDataManagerForAgricultureResource(argument: suspend GetDataManagerForAgricultureResourcePlainArgsBuilder.() -> Unit): GetDataManagerForAgricultureResourceResult {
        val builder = GetDataManagerForAgricultureResourcePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataManagerForAgricultureResourceResultToKotlin(getDataManagerForAgricultureResourcePlain(builtArgument.toJava()).await())
    }

    /**
     * Get installed extension details by extension id.
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2021-09-01-preview.
     * @param argument null
     * @return Extension resource.
     */
    public suspend fun getExtension(argument: GetExtensionPlainArgs): GetExtensionResult =
        getExtensionResultToKotlin(getExtensionPlain(argument.toJava()).await())

    /**
     * @see [getExtension].
     * @param dataManagerForAgricultureResourceName DataManagerForAgriculture resource name.
     * @param extensionId Id of extension resource.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return Extension resource.
     */
    public suspend fun getExtension(
        dataManagerForAgricultureResourceName: String,
        extensionId: String,
        resourceGroupName: String,
    ): GetExtensionResult {
        val argument = GetExtensionPlainArgs(
            dataManagerForAgricultureResourceName = dataManagerForAgricultureResourceName,
            extensionId = extensionId,
            resourceGroupName = resourceGroupName,
        )
        return getExtensionResultToKotlin(getExtensionPlain(argument.toJava()).await())
    }

    /**
     * @see [getExtension].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;agfoodplatform&#46;kotlin&#46;inputs&#46;GetExtensionPlainArgs].
     * @return Extension resource.
     */
    public suspend fun getExtension(argument: suspend GetExtensionPlainArgsBuilder.() -> Unit): GetExtensionResult {
        val builder = GetExtensionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getExtensionResultToKotlin(getExtensionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get Private endpoint connection object.
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2021-09-01-preview.
     * @param argument null
     * @return The private endpoint connection resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs): GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param dataManagerForAgricultureResourceName DataManagerForAgriculture resource name.
     * @param privateEndpointConnectionName Private endpoint connection name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @return The private endpoint connection resource.
     */
    public suspend fun getPrivateEndpointConnection(
        dataManagerForAgricultureResourceName: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            dataManagerForAgricultureResourceName = dataManagerForAgricultureResourceName,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;agfoodplatform&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return The private endpoint connection resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit): GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Get installed Solution details by Solution id.
     * Azure REST API version: 2023-06-01-preview.
     * Other available API versions: 2021-09-01-preview.
     * @param argument null
     * @return Solution resource.
     */
    public suspend fun getSolution(argument: GetSolutionPlainArgs): GetSolutionResult =
        getSolutionResultToKotlin(getSolutionPlain(argument.toJava()).await())

    /**
     * @see [getSolution].
     * @param dataManagerForAgricultureResourceName DataManagerForAgriculture resource name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param solutionId SolutionId for Data Manager For Agriculture Resource.
     * @return Solution resource.
     */
    public suspend fun getSolution(
        dataManagerForAgricultureResourceName: String,
        resourceGroupName: String,
        solutionId: String,
    ): GetSolutionResult {
        val argument = GetSolutionPlainArgs(
            dataManagerForAgricultureResourceName = dataManagerForAgricultureResourceName,
            resourceGroupName = resourceGroupName,
            solutionId = solutionId,
        )
        return getSolutionResultToKotlin(getSolutionPlain(argument.toJava()).await())
    }

    /**
     * @see [getSolution].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;agfoodplatform&#46;kotlin&#46;inputs&#46;GetSolutionPlainArgs].
     * @return Solution resource.
     */
    public suspend fun getSolution(argument: suspend GetSolutionPlainArgsBuilder.() -> Unit): GetSolutionResult {
        val builder = GetSolutionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getSolutionResultToKotlin(getSolutionPlain(builtArgument.toJava()).await())
    }
}
