@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin

import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.DataConnectorPropertiesResponse
import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.DataConnectorPropertiesResponse.Companion.toKotlin as dataConnectorPropertiesResponseToKotlin
import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DataConnector].
 */
@PulumiTagMarker
public class DataConnectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DataConnectorArgs = DataConnectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DataConnectorArgsBuilder.() -> Unit) {
        val builder = DataConnectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DataConnector {
        val builtJavaResource =
            com.pulumi.azurenative.agfoodplatform.DataConnector(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DataConnector(builtJavaResource)
    }
}

/**
 * DataConnector Model.
 * Azure REST API version: 2023-06-01-preview.
 * ## Example Usage
 * ### DataConnectors_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataConnector = new AzureNative.AgFoodPlatform.DataConnector("dataConnector", new()
 *     {
 *         DataConnectorName = "WeatherIBM",
 *         DataManagerForAgricultureResourceName = "examples-dataManagerForAgricultureResourceName",
 *         Properties = new AzureNative.AgFoodPlatform.Inputs.DataConnectorPropertiesArgs
 *         {
 *             Credentials = new AzureNative.AgFoodPlatform.Inputs.ApiKeyAuthCredentialsArgs
 *             {
 *                 ApiKey = new AzureNative.AgFoodPlatform.Inputs.KeyVaultPropertiesArgs
 *                 {
 *                     KeyName = "abcApiKey",
 *                     KeyVaultUri = "https://testKeyVault.vault.azure.net/",
 *                     KeyVersion = "239c0475c7d44f20b0fc27d3fe90a41d",
 *                 },
 *                 Kind = "ApiKeyAuthCredentials",
 *             },
 *         },
 *         ResourceGroupName = "examples-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/agfoodplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := agfoodplatform.NewDataConnector(ctx, "dataConnector", &agfoodplatform.DataConnectorArgs{
 * 			DataConnectorName:                     pulumi.String("WeatherIBM"),
 * 			DataManagerForAgricultureResourceName: pulumi.String("examples-dataManagerForAgricultureResourceName"),
 * 			Properties: &agfoodplatform.DataConnectorPropertiesArgs{
 * 				Credentials: agfoodplatform.ApiKeyAuthCredentials{
 * 					ApiKey: agfoodplatform.KeyVaultProperties{
 * 						KeyName:     "abcApiKey",
 * 						KeyVaultUri: "https://testKeyVault.vault.azure.net/",
 * 						KeyVersion:  "239c0475c7d44f20b0fc27d3fe90a41d",
 * 					},
 * 					Kind: "ApiKeyAuthCredentials",
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("examples-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.agfoodplatform.DataConnector;
 * import com.pulumi.azurenative.agfoodplatform.DataConnectorArgs;
 * import com.pulumi.azurenative.agfoodplatform.inputs.DataConnectorPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataConnector = new DataConnector("dataConnector", DataConnectorArgs.builder()
 *             .dataConnectorName("WeatherIBM")
 *             .dataManagerForAgricultureResourceName("examples-dataManagerForAgricultureResourceName")
 *             .properties(DataConnectorPropertiesArgs.builder()
 *                 .credentials(ApiKeyAuthCredentialsArgs.builder()
 *                     .apiKey(KeyVaultPropertiesArgs.builder()
 *                         .keyName("abcApiKey")
 *                         .keyVaultUri("https://testKeyVault.vault.azure.net/")
 *                         .keyVersion("239c0475c7d44f20b0fc27d3fe90a41d")
 *                         .build())
 *                     .kind("ApiKeyAuthCredentials")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("examples-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:agfoodplatform:DataConnector SatelliteSentinelHub /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AgFoodPlatform/farmBeats/{dataManagerForAgricultureResourceName}/dataConnectors/{dataConnectorName}
 * ```
 */
public class DataConnector internal constructor(
    override val javaResource: com.pulumi.azurenative.agfoodplatform.DataConnector,
) : KotlinCustomResource(javaResource, DataConnectorMapper) {
    /**
     * The ETag value to implement optimistic concurrency.
     */
    public val eTag: Output<String>
        get() = javaResource.eTag().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * DataConnector Properties.
     */
    public val properties: Output<DataConnectorPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                dataConnectorPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DataConnectorMapper : ResourceMapper<DataConnector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.agfoodplatform.DataConnector::class == javaResource::class

    override fun map(javaResource: Resource): DataConnector = DataConnector(
        javaResource as
            com.pulumi.azurenative.agfoodplatform.DataConnector,
    )
}

/**
 * @see [DataConnector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DataConnector].
 */
public suspend fun dataConnector(
    name: String,
    block: suspend DataConnectorResourceBuilder.() -> Unit,
): DataConnector {
    val builder = DataConnectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DataConnector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataConnector(name: String): DataConnector {
    val builder = DataConnectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
