@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin

import com.pulumi.azurenative.agfoodplatform.DataManagerForAgricultureResourceArgs.builder
import com.pulumi.azurenative.agfoodplatform.kotlin.enums.PublicNetworkAccess
import com.pulumi.azurenative.agfoodplatform.kotlin.inputs.IdentityArgs
import com.pulumi.azurenative.agfoodplatform.kotlin.inputs.IdentityArgsBuilder
import com.pulumi.azurenative.agfoodplatform.kotlin.inputs.SensorIntegrationArgs
import com.pulumi.azurenative.agfoodplatform.kotlin.inputs.SensorIntegrationArgsBuilder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Data Manager For Agriculture ARM Resource.
 * Azure REST API version: 2023-06-01-preview.
 * ## Example Usage
 * ### DataManagerForAgricultureResources_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataManagerForAgricultureResource = new AzureNative.AgFoodPlatform.DataManagerForAgricultureResource("dataManagerForAgricultureResource", new()
 *     {
 *         DataManagerForAgricultureResourceName = "examples-farmbeatsResourceName",
 *         Location = "eastus2",
 *         ResourceGroupName = "examples-rg",
 *         Tags =
 *         {
 *             { "key1", "value1" },
 *             { "key2", "value2" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/agfoodplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := agfoodplatform.NewDataManagerForAgricultureResource(ctx, "dataManagerForAgricultureResource", &agfoodplatform.DataManagerForAgricultureResourceArgs{
 * 			DataManagerForAgricultureResourceName: pulumi.String("examples-farmbeatsResourceName"),
 * 			Location:                              pulumi.String("eastus2"),
 * 			ResourceGroupName:                     pulumi.String("examples-rg"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("value1"),
 * 				"key2": pulumi.String("value2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.agfoodplatform.DataManagerForAgricultureResource;
 * import com.pulumi.azurenative.agfoodplatform.DataManagerForAgricultureResourceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataManagerForAgricultureResource = new DataManagerForAgricultureResource("dataManagerForAgricultureResource", DataManagerForAgricultureResourceArgs.builder()
 *             .dataManagerForAgricultureResourceName("examples-farmbeatsResourceName")
 *             .location("eastus2")
 *             .resourceGroupName("examples-rg")
 *             .tags(Map.ofEntries(
 *                 Map.entry("key1", "value1"),
 *                 Map.entry("key2", "value2")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:agfoodplatform:DataManagerForAgricultureResource examples-farmbeatsResourceName /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AgFoodPlatform/farmBeats/{dataManagerForAgricultureResourceName}
 * ```
 * @property dataManagerForAgricultureResourceName DataManagerForAgriculture resource name.
 * @property identity Identity for the resource.
 * @property location The geo-location where the resource lives
 * @property publicNetworkAccess Property to allow or block public traffic for an Azure Data Manager For Agriculture resource.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 * @property sensorIntegration Sensor integration request model.
 * @property tags Resource tags.
 */
public data class DataManagerForAgricultureResourceArgs(
    public val dataManagerForAgricultureResourceName: Output<String>? = null,
    public val identity: Output<IdentityArgs>? = null,
    public val location: Output<String>? = null,
    public val publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val sensorIntegration: Output<SensorIntegrationArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.agfoodplatform.DataManagerForAgricultureResourceArgs> {
    override fun toJava(): com.pulumi.azurenative.agfoodplatform.DataManagerForAgricultureResourceArgs = com.pulumi.azurenative.agfoodplatform.DataManagerForAgricultureResourceArgs.builder()
        .dataManagerForAgricultureResourceName(
            dataManagerForAgricultureResourceName?.applyValue({ args0 ->
                args0
            }),
        )
        .identity(identity?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .location(location?.applyValue({ args0 -> args0 }))
        .publicNetworkAccess(
            publicNetworkAccess?.applyValue({ args0 ->
                args0.transform(
                    { args0 -> args0 },
                    { args0 -> args0.let({ args0 -> args0.toJava() }) },
                )
            }),
        )
        .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
        .sensorIntegration(sensorIntegration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
        .tags(
            tags?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }),
        ).build()
}

/**
 * Builder for [DataManagerForAgricultureResourceArgs].
 */
@PulumiTagMarker
public class DataManagerForAgricultureResourceArgsBuilder internal constructor() {
    private var dataManagerForAgricultureResourceName: Output<String>? = null

    private var identity: Output<IdentityArgs>? = null

    private var location: Output<String>? = null

    private var publicNetworkAccess: Output<Either<String, PublicNetworkAccess>>? = null

    private var resourceGroupName: Output<String>? = null

    private var sensorIntegration: Output<SensorIntegrationArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value DataManagerForAgriculture resource name.
     */
    @JvmName("jvalgvtgasvcdgwd")
    public suspend fun dataManagerForAgricultureResourceName(`value`: Output<String>) {
        this.dataManagerForAgricultureResourceName = value
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("wxoqojcjqkdphfbd")
    public suspend fun identity(`value`: Output<IdentityArgs>) {
        this.identity = value
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("xvncvkldgggdbilp")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value Property to allow or block public traffic for an Azure Data Manager For Agriculture resource.
     */
    @JvmName("akluaayfimojxron")
    public suspend fun publicNetworkAccess(`value`: Output<Either<String, PublicNetworkAccess>>) {
        this.publicNetworkAccess = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bhqwtgxvscrfpenp")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Sensor integration request model.
     */
    @JvmName("chchmnxfjdppjbst")
    public suspend fun sensorIntegration(`value`: Output<SensorIntegrationArgs>) {
        this.sensorIntegration = value
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("hlbbiyrooenrbqox")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value DataManagerForAgriculture resource name.
     */
    @JvmName("qlubnjytwforppro")
    public suspend fun dataManagerForAgricultureResourceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataManagerForAgricultureResourceName = mapped
    }

    /**
     * @param value Identity for the resource.
     */
    @JvmName("dievwuwtfajskxau")
    public suspend fun identity(`value`: IdentityArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identity = mapped
    }

    /**
     * @param argument Identity for the resource.
     */
    @JvmName("txeiderpwutclunb")
    public suspend fun identity(argument: suspend IdentityArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.identity = mapped
    }

    /**
     * @param value The geo-location where the resource lives
     */
    @JvmName("rojysmypejdipdqs")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value Property to allow or block public traffic for an Azure Data Manager For Agriculture resource.
     */
    @JvmName("futgxoxqotrhnows")
    public suspend fun publicNetworkAccess(`value`: Either<String, PublicNetworkAccess>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Property to allow or block public traffic for an Azure Data Manager For Agriculture resource.
     */
    @JvmName("spldclwpvkngjqeo")
    public fun publicNetworkAccess(`value`: String) {
        val toBeMapped = Either.ofLeft<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value Property to allow or block public traffic for an Azure Data Manager For Agriculture resource.
     */
    @JvmName("bxtgfglewecuqnwd")
    public fun publicNetworkAccess(`value`: PublicNetworkAccess) {
        val toBeMapped = Either.ofRight<String, PublicNetworkAccess>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicNetworkAccess = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("vqmdyvtkvhcewfqm")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Sensor integration request model.
     */
    @JvmName("feehdffwhiosvuah")
    public suspend fun sensorIntegration(`value`: SensorIntegrationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sensorIntegration = mapped
    }

    /**
     * @param argument Sensor integration request model.
     */
    @JvmName("svavutjrpjbtadaf")
    public suspend fun sensorIntegration(argument: suspend SensorIntegrationArgsBuilder.() -> Unit) {
        val toBeMapped = SensorIntegrationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sensorIntegration = mapped
    }

    /**
     * @param value Resource tags.
     */
    @JvmName("loyqooclruccrkmj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Resource tags.
     */
    @JvmName("abnlvvgylgwqjvxg")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): DataManagerForAgricultureResourceArgs =
        DataManagerForAgricultureResourceArgs(
            dataManagerForAgricultureResourceName = dataManagerForAgricultureResourceName,
            identity = identity,
            location = location,
            publicNetworkAccess = publicNetworkAccess,
            resourceGroupName = resourceGroupName,
            sensorIntegration = sensorIntegration,
            tags = tags,
        )
}
