@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin

import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.ApiPropertiesResponse
import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.ApiPropertiesResponse.Companion.toKotlin as apiPropertiesResponseToKotlin
import com.pulumi.azurenative.agfoodplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Extension].
 */
@PulumiTagMarker
public class ExtensionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ExtensionArgs = ExtensionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ExtensionArgsBuilder.() -> Unit) {
        val builder = ExtensionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Extension {
        val builtJavaResource = com.pulumi.azurenative.agfoodplatform.Extension(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Extension(builtJavaResource)
    }
}

/**
 * Extension resource.
 * Azure REST API version: 2023-06-01-preview. Prior API version in Azure Native 1.x: 2020-05-12-preview.
 * Other available API versions: 2021-09-01-preview.
 * ## Example Usage
 * ### Extensions_CreateOrUpdate
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var extension = new AzureNative.AgFoodPlatform.Extension("extension", new()
 *     {
 *         DataManagerForAgricultureResourceName = "examples-dataManagerForAgricultureResourceName",
 *         ExtensionId = "provider.extension",
 *         ResourceGroupName = "examples-rg",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/agfoodplatform/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := agfoodplatform.NewExtension(ctx, "extension", &agfoodplatform.ExtensionArgs{
 * 			DataManagerForAgricultureResourceName: pulumi.String("examples-dataManagerForAgricultureResourceName"),
 * 			ExtensionId:                           pulumi.String("provider.extension"),
 * 			ResourceGroupName:                     pulumi.String("examples-rg"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.agfoodplatform.Extension;
 * import com.pulumi.azurenative.agfoodplatform.ExtensionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var extension = new Extension("extension", ExtensionArgs.builder()
 *             .dataManagerForAgricultureResourceName("examples-dataManagerForAgricultureResourceName")
 *             .extensionId("provider.extension")
 *             .resourceGroupName("examples-rg")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:agfoodplatform:Extension provider.extension /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.AgFoodPlatform/farmBeats/{dataManagerForAgricultureResourceName}/extensions/{extensionId}
 * ```
 */
public class Extension internal constructor(
    override val javaResource: com.pulumi.azurenative.agfoodplatform.Extension,
) : KotlinCustomResource(javaResource, ExtensionMapper) {
    /**
     * Additional Api Properties.
     */
    public val additionalApiProperties: Output<Map<String, ApiPropertiesResponse>>
        get() = javaResource.additionalApiProperties().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value.let({ args0 -> apiPropertiesResponseToKotlin(args0) }))
            }).toMap()
        })

    /**
     * The ETag value to implement optimistic concurrency.
     */
    public val eTag: Output<String>
        get() = javaResource.eTag().applyValue({ args0 -> args0 })

    /**
     * Extension api docs link.
     */
    public val extensionApiDocsLink: Output<String>
        get() = javaResource.extensionApiDocsLink().applyValue({ args0 -> args0 })

    /**
     * Extension auth link.
     */
    public val extensionAuthLink: Output<String>
        get() = javaResource.extensionAuthLink().applyValue({ args0 -> args0 })

    /**
     * Extension category. e.g. weather/sensor/satellite.
     */
    public val extensionCategory: Output<String>
        get() = javaResource.extensionCategory().applyValue({ args0 -> args0 })

    /**
     * Extension Id.
     */
    public val extensionId: Output<String>
        get() = javaResource.extensionId().applyValue({ args0 -> args0 })

    /**
     * Installed extension version.
     */
    public val installedExtensionVersion: Output<String>
        get() = javaResource.installedExtensionVersion().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ExtensionMapper : ResourceMapper<Extension> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.agfoodplatform.Extension::class == javaResource::class

    override fun map(javaResource: Resource): Extension = Extension(
        javaResource as
            com.pulumi.azurenative.agfoodplatform.Extension,
    )
}

/**
 * @see [Extension].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Extension].
 */
public suspend fun extension(name: String, block: suspend ExtensionResourceBuilder.() -> Unit): Extension {
    val builder = ExtensionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Extension].
 * @param name The _unique_ name of the resulting resource.
 */
public fun extension(name: String): Extension {
    val builder = ExtensionResourceBuilder()
    builder.name(name)
    return builder.build()
}
