@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin.inputs

import com.pulumi.azurenative.agfoodplatform.inputs.ApiKeyAuthCredentialsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * ApiKeyAuthCredentials class for ApiKey based Auth.
 * @property apiKey Properties of the key vault.
 * @property kind Enum for different types of AuthCredentials supported.
 * Expected value is 'ApiKeyAuthCredentials'.
 */
public data class ApiKeyAuthCredentialsArgs(
    public val apiKey: Output<KeyVaultPropertiesArgs>,
    public val kind: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.agfoodplatform.inputs.ApiKeyAuthCredentialsArgs> {
    override fun toJava(): com.pulumi.azurenative.agfoodplatform.inputs.ApiKeyAuthCredentialsArgs =
        com.pulumi.azurenative.agfoodplatform.inputs.ApiKeyAuthCredentialsArgs.builder()
            .apiKey(apiKey.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .kind(kind.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ApiKeyAuthCredentialsArgs].
 */
@PulumiTagMarker
public class ApiKeyAuthCredentialsArgsBuilder internal constructor() {
    private var apiKey: Output<KeyVaultPropertiesArgs>? = null

    private var kind: Output<String>? = null

    /**
     * @param value Properties of the key vault.
     */
    @JvmName("kncfwwuisejlsbfg")
    public suspend fun apiKey(`value`: Output<KeyVaultPropertiesArgs>) {
        this.apiKey = value
    }

    /**
     * @param value Enum for different types of AuthCredentials supported.
     * Expected value is 'ApiKeyAuthCredentials'.
     */
    @JvmName("haajmeckhoychkwu")
    public suspend fun kind(`value`: Output<String>) {
        this.kind = value
    }

    /**
     * @param value Properties of the key vault.
     */
    @JvmName("aeixvnkucpqocsou")
    public suspend fun apiKey(`value`: KeyVaultPropertiesArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.apiKey = mapped
    }

    /**
     * @param argument Properties of the key vault.
     */
    @JvmName("knfajshtjvawmmkl")
    public suspend fun apiKey(argument: suspend KeyVaultPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = KeyVaultPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.apiKey = mapped
    }

    /**
     * @param value Enum for different types of AuthCredentials supported.
     * Expected value is 'ApiKeyAuthCredentials'.
     */
    @JvmName("xqnamdhsqqfcwbnx")
    public suspend fun kind(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kind = mapped
    }

    internal fun build(): ApiKeyAuthCredentialsArgs = ApiKeyAuthCredentialsArgs(
        apiKey = apiKey ?: throw PulumiNullFieldException("apiKey"),
        kind = kind ?: throw PulumiNullFieldException("kind"),
    )
}
