@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin.inputs

import com.pulumi.azurenative.agfoodplatform.inputs.IdentityArgs.builder
import com.pulumi.azurenative.agfoodplatform.kotlin.enums.ResourceIdentityType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Identity for the resource.
 * @property type The identity type.
 */
public data class IdentityArgs(
    public val type: Output<ResourceIdentityType>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.agfoodplatform.inputs.IdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.agfoodplatform.inputs.IdentityArgs =
        com.pulumi.azurenative.agfoodplatform.inputs.IdentityArgs.builder()
            .type(type?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [IdentityArgs].
 */
@PulumiTagMarker
public class IdentityArgsBuilder internal constructor() {
    private var type: Output<ResourceIdentityType>? = null

    /**
     * @param value The identity type.
     */
    @JvmName("xvxssjccaojilkdv")
    public suspend fun type(`value`: Output<ResourceIdentityType>) {
        this.type = value
    }

    /**
     * @param value The identity type.
     */
    @JvmName("iukqufjbejwoetfu")
    public suspend fun type(`value`: ResourceIdentityType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): IdentityArgs = IdentityArgs(
        type = type,
    )
}
