@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin.inputs

import com.pulumi.azurenative.agfoodplatform.inputs.KeyVaultPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of the key vault.
 * @property keyName Name of Key Vault key.
 * @property keyVaultUri Uri of the key vault.
 * @property keyVersion Version of Key Vault key.
 */
public data class KeyVaultPropertiesArgs(
    public val keyName: Output<String>,
    public val keyVaultUri: Output<String>,
    public val keyVersion: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.agfoodplatform.inputs.KeyVaultPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.agfoodplatform.inputs.KeyVaultPropertiesArgs =
        com.pulumi.azurenative.agfoodplatform.inputs.KeyVaultPropertiesArgs.builder()
            .keyName(keyName.applyValue({ args0 -> args0 }))
            .keyVaultUri(keyVaultUri.applyValue({ args0 -> args0 }))
            .keyVersion(keyVersion.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [KeyVaultPropertiesArgs].
 */
@PulumiTagMarker
public class KeyVaultPropertiesArgsBuilder internal constructor() {
    private var keyName: Output<String>? = null

    private var keyVaultUri: Output<String>? = null

    private var keyVersion: Output<String>? = null

    /**
     * @param value Name of Key Vault key.
     */
    @JvmName("exwxxdgdlfduwtac")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value Uri of the key vault.
     */
    @JvmName("ufxkjptlvdyhixtt")
    public suspend fun keyVaultUri(`value`: Output<String>) {
        this.keyVaultUri = value
    }

    /**
     * @param value Version of Key Vault key.
     */
    @JvmName("nuvjretntfblrkxv")
    public suspend fun keyVersion(`value`: Output<String>) {
        this.keyVersion = value
    }

    /**
     * @param value Name of Key Vault key.
     */
    @JvmName("ybrilodifaaxbtwy")
    public suspend fun keyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value Uri of the key vault.
     */
    @JvmName("rmpbruhglscnxwbn")
    public suspend fun keyVaultUri(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVaultUri = mapped
    }

    /**
     * @param value Version of Key Vault key.
     */
    @JvmName("fsuptqytfhbrlcfn")
    public suspend fun keyVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyVersion = mapped
    }

    internal fun build(): KeyVaultPropertiesArgs = KeyVaultPropertiesArgs(
        keyName = keyName ?: throw PulumiNullFieldException("keyName"),
        keyVaultUri = keyVaultUri ?: throw PulumiNullFieldException("keyVaultUri"),
        keyVersion = keyVersion ?: throw PulumiNullFieldException("keyVersion"),
    )
}
