@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin.inputs

import com.pulumi.azurenative.agfoodplatform.inputs.SolutionPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Solution resource properties.
 * @property marketplacePublisherId SaaS application Marketplace Publisher Id.
 * @property offerId SaaS application Offer Id.
 * @property planId SaaS application Plan Id.
 * @property roleAssignmentId Role Assignment Id.
 * @property saasSubscriptionId SaaS subscriptionId of the installed SaaS application.
 * @property saasSubscriptionName SaaS subscription name of the installed SaaS application.
 * @property termId SaaS application Term Id.
 */
public data class SolutionPropertiesArgs(
    public val marketplacePublisherId: Output<String>,
    public val offerId: Output<String>,
    public val planId: Output<String>,
    public val roleAssignmentId: Output<String>? = null,
    public val saasSubscriptionId: Output<String>,
    public val saasSubscriptionName: Output<String>,
    public val termId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.agfoodplatform.inputs.SolutionPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.agfoodplatform.inputs.SolutionPropertiesArgs =
        com.pulumi.azurenative.agfoodplatform.inputs.SolutionPropertiesArgs.builder()
            .marketplacePublisherId(marketplacePublisherId.applyValue({ args0 -> args0 }))
            .offerId(offerId.applyValue({ args0 -> args0 }))
            .planId(planId.applyValue({ args0 -> args0 }))
            .roleAssignmentId(roleAssignmentId?.applyValue({ args0 -> args0 }))
            .saasSubscriptionId(saasSubscriptionId.applyValue({ args0 -> args0 }))
            .saasSubscriptionName(saasSubscriptionName.applyValue({ args0 -> args0 }))
            .termId(termId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SolutionPropertiesArgs].
 */
@PulumiTagMarker
public class SolutionPropertiesArgsBuilder internal constructor() {
    private var marketplacePublisherId: Output<String>? = null

    private var offerId: Output<String>? = null

    private var planId: Output<String>? = null

    private var roleAssignmentId: Output<String>? = null

    private var saasSubscriptionId: Output<String>? = null

    private var saasSubscriptionName: Output<String>? = null

    private var termId: Output<String>? = null

    /**
     * @param value SaaS application Marketplace Publisher Id.
     */
    @JvmName("wiuomqyrgydtnxmj")
    public suspend fun marketplacePublisherId(`value`: Output<String>) {
        this.marketplacePublisherId = value
    }

    /**
     * @param value SaaS application Offer Id.
     */
    @JvmName("rwskyojxpgvuqfrq")
    public suspend fun offerId(`value`: Output<String>) {
        this.offerId = value
    }

    /**
     * @param value SaaS application Plan Id.
     */
    @JvmName("tsippkougugtykoc")
    public suspend fun planId(`value`: Output<String>) {
        this.planId = value
    }

    /**
     * @param value Role Assignment Id.
     */
    @JvmName("huufyivbmngnwewe")
    public suspend fun roleAssignmentId(`value`: Output<String>) {
        this.roleAssignmentId = value
    }

    /**
     * @param value SaaS subscriptionId of the installed SaaS application.
     */
    @JvmName("vpgxpqsphxbikraa")
    public suspend fun saasSubscriptionId(`value`: Output<String>) {
        this.saasSubscriptionId = value
    }

    /**
     * @param value SaaS subscription name of the installed SaaS application.
     */
    @JvmName("apulrlarenywjaur")
    public suspend fun saasSubscriptionName(`value`: Output<String>) {
        this.saasSubscriptionName = value
    }

    /**
     * @param value SaaS application Term Id.
     */
    @JvmName("npgsyxsirnelkgqf")
    public suspend fun termId(`value`: Output<String>) {
        this.termId = value
    }

    /**
     * @param value SaaS application Marketplace Publisher Id.
     */
    @JvmName("hgxgodnqftpgprgn")
    public suspend fun marketplacePublisherId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.marketplacePublisherId = mapped
    }

    /**
     * @param value SaaS application Offer Id.
     */
    @JvmName("vehsfnadleqbmtct")
    public suspend fun offerId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.offerId = mapped
    }

    /**
     * @param value SaaS application Plan Id.
     */
    @JvmName("kplkgiejbyuvkcva")
    public suspend fun planId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.planId = mapped
    }

    /**
     * @param value Role Assignment Id.
     */
    @JvmName("swbbnqxnrnhktcah")
    public suspend fun roleAssignmentId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleAssignmentId = mapped
    }

    /**
     * @param value SaaS subscriptionId of the installed SaaS application.
     */
    @JvmName("mxfytwrfrvvakgjp")
    public suspend fun saasSubscriptionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.saasSubscriptionId = mapped
    }

    /**
     * @param value SaaS subscription name of the installed SaaS application.
     */
    @JvmName("nsotaghoiakoeohe")
    public suspend fun saasSubscriptionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.saasSubscriptionName = mapped
    }

    /**
     * @param value SaaS application Term Id.
     */
    @JvmName("nexgklmkvgwixyld")
    public suspend fun termId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.termId = mapped
    }

    internal fun build(): SolutionPropertiesArgs = SolutionPropertiesArgs(
        marketplacePublisherId = marketplacePublisherId ?: throw
            PulumiNullFieldException("marketplacePublisherId"),
        offerId = offerId ?: throw PulumiNullFieldException("offerId"),
        planId = planId ?: throw PulumiNullFieldException("planId"),
        roleAssignmentId = roleAssignmentId,
        saasSubscriptionId = saasSubscriptionId ?: throw PulumiNullFieldException("saasSubscriptionId"),
        saasSubscriptionName = saasSubscriptionName ?: throw
            PulumiNullFieldException("saasSubscriptionName"),
        termId = termId ?: throw PulumiNullFieldException("termId"),
    )
}
