@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The error detail.
 * @property additionalInfo The error additional info.
 * @property code The error code.
 * @property details The error details.
 * @property message The error message.
 * @property target The error target.
 */
public data class ErrorDetailResponse(
    public val additionalInfo: List<ErrorAdditionalInfoResponse>,
    public val code: String,
    public val details: List<ErrorDetailResponse>,
    public val message: String,
    public val target: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.agfoodplatform.outputs.ErrorDetailResponse): ErrorDetailResponse = ErrorDetailResponse(
            additionalInfo = javaType.additionalInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.agfoodplatform.kotlin.outputs.ErrorAdditionalInfoResponse.Companion.toKotlin(args0)
                })
            }),
            code = javaType.code(),
            details = javaType.details().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.agfoodplatform.kotlin.outputs.ErrorDetailResponse.Companion.toKotlin(args0)
                })
            }),
            message = javaType.message(),
            target = javaType.target(),
        )
    }
}
