@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Data Manager For Agriculture ARM Resource.
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property identity Identity for the resource.
 * @property instanceUri Uri of the Data Manager For Agriculture instance.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property privateEndpointConnections Private endpoints.
 * @property provisioningState Data Manager For Agriculture instance provisioning state.
 * @property publicNetworkAccess Property to allow or block public traffic for an Azure Data Manager For Agriculture resource.
 * @property sensorIntegration Sensor integration request model.
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetDataManagerForAgricultureResourceResult(
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val instanceUri: String,
    public val location: String,
    public val name: String,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>,
    public val provisioningState: String,
    public val publicNetworkAccess: String? = null,
    public val sensorIntegration: SensorIntegrationResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.agfoodplatform.outputs.GetDataManagerForAgricultureResourceResult): GetDataManagerForAgricultureResourceResult = GetDataManagerForAgricultureResourceResult(
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.agfoodplatform.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            instanceUri = javaType.instanceUri(),
            location = javaType.location(),
            name = javaType.name(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.agfoodplatform.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            sensorIntegration = javaType.sensorIntegration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.agfoodplatform.kotlin.outputs.SensorIntegrationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.agfoodplatform.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
