@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of the key vault.
 * @property keyName Name of Key Vault key.
 * @property keyVaultUri Uri of the key vault.
 * @property keyVersion Version of Key Vault key.
 */
public data class KeyVaultPropertiesResponse(
    public val keyName: String,
    public val keyVaultUri: String,
    public val keyVersion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.agfoodplatform.outputs.KeyVaultPropertiesResponse): KeyVaultPropertiesResponse = KeyVaultPropertiesResponse(
            keyName = javaType.keyName(),
            keyVaultUri = javaType.keyVaultUri(),
            keyVersion = javaType.keyVersion(),
        )
    }
}
