@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.agfoodplatform.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * OAuthClientCredentials for clientId clientSecret auth.
 * @property clientId ClientId associated with the provider.
 * @property clientSecret Properties of the key vault.
 * @property kind Enum for different types of AuthCredentials supported.
 * Expected value is 'OAuthClientCredentials'.
 */
public data class OAuthClientCredentialsResponse(
    public val clientId: String,
    public val clientSecret: KeyVaultPropertiesResponse,
    public val kind: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.agfoodplatform.outputs.OAuthClientCredentialsResponse): OAuthClientCredentialsResponse = OAuthClientCredentialsResponse(
            clientId = javaType.clientId(),
            clientSecret = javaType.clientSecret().let({ args0 ->
                com.pulumi.azurenative.agfoodplatform.kotlin.outputs.KeyVaultPropertiesResponse.Companion.toKotlin(args0)
            }),
            kind = javaType.kind(),
        )
    }
}
